/*
 * @Descripttion:
 * @version:
 * @Author: zhouyh
 * @Date: 2021-09-16 10:50:09
 * @LastEditors: zhouyh
 * @LastEditTime: 2021-11-11 17:12:25
 */
const publicPath = process.env.NODE_ENV === "production" ? "././" : "./";

module.exports = {
  publicPath,
  productionSourceMap: process.env.NODE_ENV === 'production' ? false : true,
  devServer: {
    disableHostCheck: true,
    proxy: {
      '/baiduapi': {
        target: 'https://apis.map.qq.com/',
        pathRewrite: {
          '^/baiduapi': ''
        }
      },
      '/appointment': {
        target: 'https://appointment.smart-zj.cn/api/appointment/',
        changOrigin: true,
        pathRewrite: {
          '^/appointment': ''
        }
      }
    }
  },
  configureWebpack: {
    externals: {
      BMapGL: "BMapGL",
      AMap: 'AMap',
      wx: 'wx',
      AlipayJSBridge: 'AlipayJSBridge',
      qq: 'qq'
    },
  },
};
