import { request, config } from '@/utils/request'
import { request2, config2 } from '@/utils/axios'


/**
 * 获取公积金账号
 */
export function getAccount(data) {
  return request({
    // headers: { "Content-Type": "application/x-www-form-urlencoded" },
    url: `${config.baseUrl}user/getFund`,
    method: 'post',
    params: data
  })
}

/**
 * 自然人公积金缴纳信息
 */
export function fundInfo(data) {
  return request2({
    url: `${config2.baseSocUrl}app-api/houseFund/naturalPersonInformation`,
    method: 'post',
    params: data
  })
}

/**
 * 自然人公积金缴纳明细信息
 */
export function fundDet(data) {
  return request2({
    url: `${config2.baseSocUrl}app-api/houseFund/naturalPersonDetail`,
    method: 'post',
    params: data
  })
}

/**
 * 个人公积金贷款基本信息
 */
export function loanInfo(data) {
  return request2({
    url: `${config2.baseSocUrl}app-api/houseFund/personalLoan`,
    method: 'post',
    params: data
  })
}

/**
 * 个人公积金贷款还款明细
 */
export function fundLoanDet(data) {
  return request2({
    url: `${config2.baseSocUrl}app-api/houseFund/personalRepayment`,
    method: 'post',
    params: data
  })
}