import { env } from '../config'
import { Toast } from 'vant'
// import AlipayJSBridge from 'AlipayJSBridge'
function whatWebView () {
  var e = window.navigator.userAgent.toLowerCase()
  // dtdreamweb 就是这政厅环境
  var t = e.indexOf('dtdreamweb') > -1
  var r = e.indexOf('hanweb') > -1 && !t
  var n = e.indexOf('micromessenger') > -1
  var o = e.indexOf('alipayclient') > -1
  var i =
    (e.indexOf('miniprogram') > -1 || e.indexOf('alipayide') > -1) &&
    e.indexOf('alipay') > -1
  var a = e.indexOf('eshiminapp') > -1
  var s = e.indexOf('iflytek_mmp') > -1
  var c = e.indexOf('miniprogram') > -1 && e.indexOf('dingtalk') > -1
  var u = e.indexOf('dingtalk') > -1
  var l = e.indexOf('000001@jcss') > -1
  return t
    ? 'dtdream'
    : r
      ? 'hanweb'
      : a
        ? 'eshimin'
        : s
          ? 'iflytek'
          : n
            ? 'wetchat'
            : c
              ? 'dingtalkMini'
              : u
                ? 'dingtalk'
                : i
                  ? 'alipayMini'
                  : o
                    ? 'alipay'
                    : l
                      ? 'JCSS'
                      : 'other'
}

export const isInApp =
  window?.webkit?.messageHandlers?.getUserInfo?.postMessage ||
  window?.android?.getUserInfo

const mock = {
  mobileNo: '',
  userId: '',
  name: '',
  realName: '',
  idCardNo: ''
}

const mockFun = function () {
  sessionStorage.setItem('zj-info', JSON.stringify(mock))
}

export const jsBridge = {
  getUserInfo () {
    return new Promise((resolve, reject) => {
      if (window.android !== undefined) {
        const res = window.android.getUserInfo()
        sessionStorage.setItem('zj-info', res)
        resolve(JSON.parse(res))
      } else if (window.webkit) {
        // 有可能出现在ios手机中
        if (whatWebView() !== 'other') {
          // 这是常用app扫描出来的 没有登陆
          if (env === 'dev') {
            mockFun()
            resolve(mock)
            return
          } else {
            // 判断正式环境应该怎么处理
            reject(new Error('跳无登录页面的页面'))
            return
          }
        }
        window.getUserInfo = function (res) {
          sessionStorage.setItem('zj-info', res)
          resolve(JSON.parse(res))
        }
        window.webkit.messageHandlers.getUserInfo.postMessage('getUserInfo')
      } else {
        if (env === 'dev') {
          mockFun()
          resolve(mock)
        } else {
          // 判断正式环境应该怎么处理
          reject(new Error('跳无登录页面的页面'))
        }
      }
    })
  },

  getPoint () {
    return new Promise((resolve) => {
      const loading1 = Toast.loading({
        message: '加载中...',
        forbidClick: true,
        // duration: 0,
        loadingType: 'spinner'
      })
        window.receiveLocation = function (data) {
          const row = JSON.parse(data)
          loading1.clear()
          if (row.code == 0) {
            // 根据坐标得到地址描述
            resolve(row.data)
          } else {
            resolve({ lng: 119.425722, lat: 32.188478, type: 'gcj02' })
          }
        }
        if (window.android !== undefined) {
          if (typeof window.android.getLocationInfos === 'undefined') {
            resolve({ lng: 119.425722, lat: 32.188478, type: 'gcj02' })
            // reject();
          } else {
            window.android.getLocationInfos() // 这是一个json字符串
          }
        } else if (window.webkit) {
          // ios
          if (
            typeof window.webkit.messageHandlers.getLocationInfos ===
            'undefined'
          ) {
            resolve({ lng: 119.425722, lat: 32.188478, type: 'gcj02' })
          } else {
            window.webkit.messageHandlers.getLocationInfos.postMessage(
              'getLocationInfos'
            )
          }
        } else {
          loading1.clear()
          resolve({ lng: 119.425722, lat: 32.188478, type: 'gcj02' })
        }
      }
    )
  }
}
