import { request, config, formatUrl } from '@/utils/request'

/**
 * 缴费
 */
export function payWeb(data) {
  return request({
    url: `${config.baseUrl}naturalGas/payWeb${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}


/**
 * 查询缴费用户信息
 */
 export function queryPayUserInfo(data) {
  return request({
    url: `${config.baseUrl}naturalGas/queryPayUserInfo${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 绑定用户信息
 */
 export function userBind(data) {
  return request({
    url: `${config.baseUrl}naturalGas/userBind`,
    method: 'post',
    data: data
  })
}

/**
 * 查询用户信息
 */
 export function queryListUser(data) {
  return request({
    url: `${config.baseUrl}naturalGas/queryListUser${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 解绑用户信息
 */
 export function userUnBind(data) {
  return request({
    url: `${config.baseUrl}naturalGas/userUnBind${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 查询燃气费&业务费欠费信息
 */
 export function queryArrears(data) {
  return request({
    url: `${config.baseUrl}naturalGas/queryArrears${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 切换默认用户
 */
 export function defaultUserBind(data) {
  return request({
    url: `${config.baseUrl}naturalGas/defaultUserBind${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 图片上传
 */
 export function imageUpload(data) {
  return request({
    url: `${config.baseUrl}/naturalGas/imageUpload`,
    method: 'post',
    data: data
  })
}

/**
 * 预约维修
 */
 export function appIntMaintain(data) {
  return request({
    url: `${config.baseUrl}/naturalGas/appIntMaintain${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 预约安检
 */
 export function appointSecurityCheck(data) {
  return request({
    url: `${config.baseUrl}/naturalGas/appointSecurityCheck${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 点火通气
 */
 export function appointVentilation(data) {
  return request({
    url: `${config.baseUrl}/naturalGas/appointVentilation${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}