import { config,request,formatUrl } from '@/utils/request'

/**
 * 判断用户扫描类型
 */
 export function judgeUserType(data){
    return request({
        url: `${config.baseUrl}fruits/judgeUserType`,
        method: 'post',
        data: data
    })
}

/**
 * 查询详情
 */
 export function queryOffLineQrCodeInfo(data){
    return request({
        url: `${config.baseUrl}fruits/queryOffLineQrCodeInfo${formatUrl(data)}`,
        method: 'post',
        data: data
    })
}

/**
 * 线下卷确认提货
 */
 export function offlineConfirmPickUpGoods(data){
    return request({
        url: `${config.baseUrl}fruits/offlineConfirmPickUpGoods`,
        method: 'post',
        data: data
    })
}

/**
 * 线上卷确认提货
 */
 export function onLinePickUpGoods(data){
    return request({
        url: `${config.baseUrl}fruits/onLinePickUpGoods`,
        method: 'post',
        data: data
    })
}

/**
* 待初始化卷转为线下卷
*/
export function onLineToOffLine(data){
   return request({
       url: `${config.baseUrl}fruits/onLineToOffLine${formatUrl(data)}`,
       method: 'post',
       data: data
   })
}

/**
 * 水果查询
 */
 export function getFruits(data){
    return request({
        url: `${config.baseUrl}fruits/getFruits`,
        method: 'post',
        data: data
    })
}

/**
 * 用户线上兑换历史
 */
 export function userOnlineRecord(data){
    return request({
        url: `${config.baseUrl}fruits/userOnlineRecord${formatUrl(data)}`,
        method: 'post',
        data: data
    })
}

/**
 * 核验统计
 */
 export function verificationStatistics(data){
    return request({
        url: `${config.baseUrl}fruits/verificationStatistics${formatUrl(data)}`,
        method: 'post',
        data: data
    })
}