import Vue from "vue";
import axios from "axios";

import { Toast } from "vant";
Vue.use(Toast);
// 配置环境
const env = process.env.NODE_ENV === "development" ? "dev" : "prod";

const baseUrl = {
  // dev: "http://192.168.3.98:9090/",
  // dev: "http://192.168.3.144:9090/",
  dev: "http://81.69.231.72:9090/",
  // dev: "https://www.smart-zj.cn:55901/cert/",

  // prod: 'http://81.69.231.72:9090/',
  prod: "https://www.smart-zj.cn:55901/cert/",
};
const baseH5 = {
  // dev: "http://www.smart-zj.cn:55902/zjh/html/pages/#/",
  dev: "http://81.69.44.115/zjh/html/pages/#/",
  // prod: 'http://81.69.44.115/zjh/html/pages/#/',
  prod: "http://www.smart-zj.cn:55902/zjh/html/pages/#/",
};
const config = {
  baseUrl: baseUrl[env],
  baseH5: baseH5[env],
  // baseUrl: 'http://81.69.231.72:9090/',   // 测试
  // baseH5: 'http://81.69.44.115/zjh/html/pages/#/',  // 测试

  // baseUrl: 'https://www.smart-zj.cn:55901/cert/',   // 生产
  // baseH5: 'http://www.smart-zj.cn:55902/zjh/html/pages/#/', // 生产
  baseSocUrl: "https://www.smart-zj.cn:55901/soc/", // 公积金社保
  baseServiceUrl: "http://58.217.53.110/epoint-web-zwdt/rest/", // 政务np服务
  basePurchase:
    "http://zfcg.ggzy.zhenjiang.gov.cn/WebBuilderMobileService/appservice/", // 公共资源采购
};

const request = axios.create({
  timeout: 30000,
  withCredentials: false,
});

request.interceptors.request.use(
  (config) => {
    config.headers = config.headers || {
      "Content-Type": "application/json",
    };
    // if (config.method === 'post') {
    //   config.data = { ...config.data }
    // } else if (config.method === 'get') {
    //   config.params = { ...config.params }
    // }
    return config;
  },
  (error) => {
    console.log(error);
    return Promise.reject(error);
  }
);

request.interceptors.response.use(
  (response) => {
    const res = response.data;
    if (response.config.url.indexOf(config.basePurchase) !== -1) {
      if (res.EpointDataBody.DATA.ReturnInfo.Status === "True") {
        return res;
      } else {
        Toast(res.EpointDataBody.DATA.ReturnInfo.Description || "网络错误");
        return Promise.reject(
          new Error(
            res.EpointDataBody.DATA.ReturnInfo.Description || "网络错误"
          )
        );
      }
    } else if (response.config.url.indexOf(config.baseServiceUrl) !== -1) {
      if (res.status.code === 200) {
        return res;
      } else {
        Toast(res.status.text || "网络错误");
        return Promise.reject(new Error(res.status.text || "网络错误"));
      }
    } else {
      if (parseInt(res.code) === 200) {
        return res.data || res.message;
      } else {
        Toast(res.message || "网络错误");
        return Promise.reject(new Error(res.message || "网络错误"));
      }
    }
  },
  (error) => {
    Toast.clear();
    console.log("err" + error);
    Toast(error.message || "网络错误");
    return Promise.reject(error);
  }
);
const request1 = axios.create({
  timeout: 30000,
  withCredentials: false,
});

request1.interceptors.request.use(
  (config) => {
    config.headers = config.headers || {
      "Content-Type": "application/json",
    };
    // if (config.method === 'post') {
    //   config.data = { ...config.data }
    // } else if (config.method === 'get') {
    //   config.params = { ...config.params }
    // }
    return config;
  },
  (error) => {
    console.log(error);
    return Promise.reject(error);
  }
);

request1.interceptors.response.use(
  (response) => {
    // alert(JSON.stringify(response))
    const res = response.data;
    if (response.config.url.indexOf(config.basePurchase) !== -1) {
      if (res.EpointDataBody.DATA.ReturnInfo.Status === "True") {
        return res;
      } else {
        Toast(res.EpointDataBody.DATA.ReturnInfo.Description || "网络错误");
        return Promise.reject(
          new Error(
            res.EpointDataBody.DATA.ReturnInfo.Description || "网络错误"
          )
        );
      }
    } else if (response.config.url.indexOf(config.baseServiceUrl) !== -1) {
      if (res.status.code === 200) {
        return res;
      } else {
        Toast(res.status.text || "网络错误");
        return Promise.reject(new Error(res.status.text || "网络错误"));
      }
    } else {
      if (parseInt(res.code) === 200) {
        return res;
      } else {
        // Toast(res.message || "网络错误");
        return Promise.reject(new Error(res.message || "网络错误"));
      }
    }
  },
  (error) => {
    Toast.clear();
    console.log("err" + error);
    Toast(error.message || "网络错误");
    return Promise.reject(error);
  }
);

const formatUrl = (params) => {
  let ary = [];
  Object.keys(params).map((key) => {
    ary.push(encodeURIComponent(key) + "=" + encodeURIComponent(params[key]));
    // if (params[key]) {
    //   ary.push(encodeURIComponent(key) + '=' + encodeURIComponent(params[key]));
    // }
  });
  let urlStr = ary.join("&");
  return `?${urlStr}`;
};

export { config, request,request1, formatUrl };
