import { request, config, formatUrl } from '@/utils/request'

// /**
//  * 通过ticket查询用户实名信息
//  */
 export function querySfbUserInfo(data) {
  return request({
    url: `${config.baseUrl}dock/querySfbUserInfo${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 上传照片文件
 * @param {Object} data
 */
export function uploadFile(data) {
  return request({
    headers: { "Content-Type": "multipart/form-data" },
    // url: `${config.baseUrl}file/uploadTalent`,
    url: `${config.baseUrl}file/upload`,
    method: 'post',
    data: data
  })
}

/**
 * 查询类型
 * @param {Object} data
 */
export function getType(data) {
  return request({
    url: `${config.baseUrl}talent/getType`,
    method: 'get',
    params: data
  })
}

/**
 * 查询类型
 * @param {Object} data
 */
export function getCategory(data) {
  return request({
    url: `${config.baseUrl}talent/getCategory`,
    method: 'post',
    data: data
  })
}

/**
 * 行为统计1
 * @param {Object} data
 */
 export function addBehavior(data) {
  return request({
    url: `${config.baseUrl}talent/addBehavior`,
    method: 'post',
    data: data
  })
}

/**
 * 行为统计2
 * @param {Object} data
 */
 export function addAccumulationFundScan(data) {
  return request({
    url: `${config.baseUrl}scattered/addAccumulationFundScan`,
    method: 'post',
    data: data
  })
}

/**
 * 查询用户实名信息
 */
 export function queryUser(data) {
  return request({
    url: `${config.baseUrl}user/queryUser${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 查询内容
 * @param {Object} data
 */
export function getContent(data) {
  return request({
    url: `${config.baseUrl}talent/getContent`,
    method: 'post',
    data: data
  })
}

/**
 * 查询详情
 */
export function get(data) {
  return request({
    url: `${config.baseUrl}talent/get`,
    method: 'post',
    data: data
  })
}
/**
 * 根据二维码查询详情
 */
export function getCodeDetails(data) {
  return request({
    url: `${config.baseUrl}talent/getCodeDetails`,
    method: 'post',
    data: data
  })
}

/**
 * 提交/保存
 */
export function add(data) {
  return request({
    url: `${config.baseUrl}talent/add`,
    method: 'post',
    data: data
  })
}

/**
 * 修改提交/保存
 */
export function update(data) {
  return request({
    url: `${config.baseUrl}talent/update`,
    method: 'post',
    data: data
  })
}

/**
 * 删除
 */
export function del(data) {
  return request({
    url: `${config.baseUrl}talent/delete`,
    method: 'post',
    data: data
  })
}

/**
 * 修改状态
 */
export function updateState(data) {
  return request({
    url: `${config.baseUrl}talent/updateState`,
    method: 'post',
    data: data
  })
}

/**
 * 公式名单
 */
export function getList(data) {
  return request({
    url: `${config.baseUrl}talent/getList`,
    method: 'post',
    data: data
  })
}

/**
 * 查询人才名单
 */
export function getPersonnel(data) {
  return request({
    url: `${config.baseUrl}talent/getPersonnel`,
    method: 'post',
    data: data
  })
}

/**
 * 查询权限
 */
 export function userScanPermission(data) {
  return request({
    url: `${config.baseUrl}scattered/userScanPermission${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}