import { request1, config } from '@/utils/request'
// import axios from 'axios'
// import { request, config, formatUrl } from '@/utils/request'

/**
 * 查询本人通行码
 */
export function getOwn(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/queryOwnPermitCode`,
        method: 'get',
        params: data
    })
}

/**
 * 查询家人通行码
 */
export function getFamily(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/queryListFamilyPermitCode`,
        method: 'get',
        params: data
    })
}

/**
 * 上传照片文件
 * @param {Object} data
 */
export function uploadFile(data) {
    return request1({
        headers: { "Content-Type": "multipart/form-data" },
        url: `${config.baseUrl}file/permitCodeUpload`,
        method: 'post',
        data: data
    })
}

/**
 * 添加个人通行码
 */
export function addUserPermitCode(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/addUserPermitCode`,
        method: 'post',
        data: data
    })
}

/**
 * 删除个人通行码
 */
export function delUserPermitCode(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/delUserPermitCode`,
        method: 'post',
        data: data
    })
}

/**
 * 修改个人通行码
 */
export function updateUserPermitCode(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/updateUserPermitCode`,
        method: 'post',
        data: data
    })
}

/**
 * 查询企业通行码
 */
export function queryListEnterprisePermitCode(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/queryListEnterprisePermitCode`,
        method: 'get',
        params: data
    })
}

/**
 * 查询通行码授权的员工信息
 */
export function queryListAuthUser(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/queryListAuthUser`,
        method: 'post',
        data: data
    })
}

/**
 * 查询通行码授权的员工信息
 */
export function addAuthUser(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/addAuthUser`,
        method: 'post',
        data: data
    })
}

/**
 * 删除授权的员工信息
 */
export function delAuthUser(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/delAuthUser`,
        method: 'post',
        data: data
    })
}

/**
 * 查询企业信息
 */
export function queryEnterpriseInfo(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/queryEnterpriseInfo`,
        method: 'get',
        params: data
    })
}

/**
 * 企业申请权限
 */
export function addEnterprise(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/addEnterprise`,
        method: 'post',
        data: data
    })
}

/**
 * 企业申请权限修改
 */
export function updateEnterprise(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/updateEnterprise`,
        method: 'post',
        data: data
    })
}

/**
 * 查询员工扫码权限
 */
export function queryStaffScanPower(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/queryStaffScanPower`,
        method: 'get',
        params: data
    })
}

/**
 * 查询通行码信息
 */
 export function queryUserPermitCodeInfo(data) {
    return request1({
        url: `${config.baseUrl}personalTravel/queryUserPermitCodeInfo`,
        method: 'get',
        params: data
    })
}