import { request, request1, config } from '@/utils/request'

/**
 * 上传照片文件
 * @param {Object} data
 */
export function uploadFile(data) {
    return request({
        headers: { "Content-Type": "multipart/form-data" },
        // url: `${config.baseUrl}file/DeedTaxUpload`,
        url: `${config.baseUrl}file/upload`,
        method: 'post',
        data: data
    })
}

/**
 * 契税补贴申请列表
 */
export function queryListDeedTaxInfoByUserId(data) {
    return request1({
        url: `${config.baseUrl}deedTax/queryListDeedTaxInfoByUserId`,
        method: 'post',
        data: data
    })
}

/**
 * 契税补贴申请新增
 */
export function addDeedTax(data) {
    return request1({
        url: `${config.baseUrl}deedTax/addDeedTax`,
        method: 'post',
        data: data
    })
}

/**
 * 契税补贴初审审核意见
 */
export function queryReviewerDeedTaxRecord(data) {
    return request1({
        url: `${config.baseUrl}deedTax/queryReviewerDeedTaxRecord`,
        method: 'post',
        data: data
    })
}

/**
 * 契税补贴审核意见
 */
export function queryDeedTaxRecord(data) {
    return request1({
        url: `${config.baseUrl}deedTax/queryDeedTaxRecord`,
        method: 'post',
        data: data
    })
}

/**
 * 契税补贴查询详情
 */
export function queryDeedTaxInfoByCode(data) {
    return request1({
        url: `${config.baseUrl}deedTax/queryDeedTaxInfoByCode`,
        method: 'post',
        data: data
    })
}

/**
 * 契税补贴申请修改
 */
export function updateDeedTax(data) {
    return request1({
        url: `${config.baseUrl}deedTax/updateDeedTax`,
        method: 'post',
        data: data
    })
}

/**
 * 银行卡确认
 */
export function updateDeedTaxState(data) {
    return request1({
        url: `${config.baseUrl}deedTax/updateDeedTaxState`,
        method: 'post',
        data: data
    })
}

/**
 * 查询用户申请记录
 */
export function queryUserApplyForRecord(data) {
    return request1({
        url: `${config.baseUrl}deedTax/queryUserApplyForRecord`,
        method: 'post',
        data: data
    })
}

/**
 * 查询用户申请中的详细信息
 */
export function queryApplyingDeedTaxInfo(data) {
    return request1({
        url: `${config.baseUrl}deedTax/queryApplyingDeedTaxInfo`,
        method: 'post',
        data: data
    })
}