import { request, config, formatUrl } from '@/utils/request'

/**
 * 上传照片文件
 * @param {Object} data
 */
export function uploadFile(data) {
  return request({
    headers: { "Content-Type": "multipart/form-data" },
    // url: `${config.baseUrl}file/sportUpload`, //minio溢出
    url: `${config.baseUrl}file/coldChainUpload`,
    method: 'post',
    data: data
  })
}

/**
 * 冷链食品申报
 * @param {Object} data
 */
export function report(data) {
  return request({
    url: `${config.baseUrl}cold/add`,
    method: 'post',
    data: data
  })
}

/**
 * 冷链食品申报修改
 * @param {Object} data
 */
export function update(data) {
  return request({
    url: `${config.baseUrl}cold/update`,
    method: 'post',
    data: data
  })
}

/**
 * 冷链食品申报详情
 * @param {Object} data
 */
export function detail(data) {
  return request({
    url: `${config.baseUrl}cold/get`,
    method: 'post',
    data: data
  })
}

/**
 * 我的预约列表
 */
export function reportList(data) {
  return request({
    url: `${config.baseUrl}cold/getList`,
    method: 'post',
    data: data
  })
}

/**
 * 修改申报单转态
 */
export function updateState(data) {
  return request({
    url: `${config.baseUrl}cold/updateState`,
    method: 'post',
    data: data
  })
}

/**
 * 根据车牌号查询列表
 */
export function getCarNumber(data) {
  return request({
    url: `${config.baseUrl}cold/getCarNumber`,
    method: 'post',
    data: data
  })
}

/**
 * 自主申报
 */
export function reportSelf(data) {
  return request({
    url: `${config.baseUrl}cold/addSelf`,
    method: 'post',
    data: data
  })
}

/**
 * 查询自主申报
 */
export function getSelf(data) {
  return request({
    url: `${config.baseUrl}cold/getSelf`,
    method: 'post',
    data: data
  })
}

/**
 * 修改自主申报
 */
export function updateSelf(data) {
  return request({
    url: `${config.baseUrl}cold/updateSelf`,
    method: 'post',
    data: data
  })
}

/**
 * 查询仓库列表
 */
export function getAddress(data) {
  return request({
    url: `${config.baseUrl}cold/getAddress`,
    method: 'post',
    data: data
  })
}

/**
 * 查询企业经营类型
 */
export function getOperate(data) {
  return request({
    url: `${config.baseUrl}cold/getOperate`,
    method: 'post',
    data: data
  })
}

/**
 * 添加溯源
 */
export function addTracing(data) {
  return request({
    url: `${config.baseUrl}cold/addTracing`,
    method: 'post',
    data: data
  })
}

/**
 * 获取公共服务电话
 */
export function getPhone(data) {
  return request({
    url: `${config.baseUrl}cold/getPhone`,
    method: 'get',
    params: data
  })
}

/**
 * 地区选择
 */
export function getArea(data) {
  return request({
    url: `${config.baseUrl}sport/getArea`,
    method: 'get',
    params: data
  })
}

/**
 * 货物商品类型
 */
 export function getProductTypeDict(data) {
  return request({
    url: `${config.baseUrl}coldThirdParty/getProductTypeDict`,
    method: 'get',
    params: data
  })
}

/**
 * 货物商品类型
 */
 export function getHSCodeDict(data) {
  return request({
    url: `${config.baseUrl}coldThirdParty/getHSCodeDict`,
    method: 'get',
    params: data
  })
}

/**
 * 入境口岸选择
 */
 export function getPortEntryDict(data) {
  return request({
    url: `${config.baseUrl}coldThirdParty/getPortEntryDict`,
    method: 'get',
    params: data
  })
}

/**
 * 原产地选择
 */
 export function getCountryDict(data) {
  return request({
    url: `${config.baseUrl}coldThirdParty/getCountryDict`,
    method: 'get',
    params: data
  })
}

/**
 * 企业信息选择
 */
 export function getCompanyInfo(data) {
  return request({
    url: `${config.baseUrl}coldThirdParty/getCompanyInfo`,
    method: 'get',
    params: data
  })
}

/**
 * 添加溯源
 */
 export function coldThirdPartyupload(data) {
  return request({
    url: `${config.baseUrl}coldThirdParty/upload${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}