import CryptoJS from "crypto-js";

// 获取未来某段时间的日期
export function getDays(leng) {
    const now = new Date();
    const nowTime = now.getTime();
    const oneDayTime = 24 * 60 * 60 * 1000;
    let timeArr = [];
    let timeStr = "";
    for (var i = 0; i < leng; i++) {
        //显示星期
        let ShowTime = nowTime + i * oneDayTime;
        //初始化日期时间
        let myDate = new Date(ShowTime);
        let year = myDate.getFullYear();
        let month = myDate.getMonth() + 1;
        month = month > 9 ? month : `0${month}`;
        let date = myDate.getDate();
        date = date > 9 ? date : `0${date}`;
        timeStr = year + "-" + month + "-" + date;
        timeArr.push(timeStr);
    }CryptoJS
    return timeArr;
}

// 将数组中的对象按照某一个元素分类
export function dealWithData(data, param) {
    let c = [];
    let d = {};
    data.forEach((element) => {
        if (!d[element[param]]) {
            c.push({
                param: element[param],
                child: [element],
            });
            d[element[param]] = element;
        } else {
            c.forEach((ele) => {
                if (ele.param === element[param]) {
                    ele.child.push(element);
                }
            });
        }
    });
    return c;
}

// 冷链食品状态枚举
export function coldfoodEnume(state) {
    switch (state) {
        case 0:
            return "待App审核";
        case 1:
            return "后台审核通过(待预约入库)";
        case 2:
            return "已驳回";
        case 3:
            return "已撤回";
        case 4:
            return "已入库(待检测)";
        case 5:
            return "消杀通过(待出库)";
        case 6:
            return "消杀未通过";
        case 7:
            return "检测通过(待消杀)";
        case 8:
            return "检测未通过(待灭活)";
        case 9:
            return "已出库";
        case 10:
            return "已灭活";
        case 11:
            return "App审核通过(待管理员审核)";
        case 12:
            return "预约入库通过(待入库审核)";
        case 13:
            return "入库审核通过(待入库)";
        default:
            return "未知状态";
    }
}

// des加密
export function encryptByDES(message, key) {
    const keyHex = CryptoJS.enc.Utf8.parse(key); // 秘钥
    let newMessage = "" + message;
    const encrypted = CryptoJS.DES.encrypt(newMessage, keyHex, {
        mode: CryptoJS.mode.ECB, // 加密模式
        padding: CryptoJS.pad.Pkcs7,
    });
    return encrypted.toString(); //  加密出来为 hex格式密文
}

// des解密
export function decryptByDES(ciphertext, key) {
    const keyHex = CryptoJS.enc.Utf8.parse(key);
    console.log(ciphertext);
    const decrypted = CryptoJS.DES.decrypt({
            ciphertext: CryptoJS.enc.Base64.parse(ciphertext),
        },
        keyHex, {
            mode: CryptoJS.mode.ECB,
            padding: CryptoJS.pad.Pkcs7,
        }
    );
    return decrypted.toString(CryptoJS.enc.Utf8);
}

// base64解密
export function decryptBase(ciphertext) {
    var parsedWordArray = CryptoJS.enc.Base64.parse(ciphertext);
    var parsedStr = parsedWordArray.toString(CryptoJS.enc.Utf8);
    return parsedStr;
}

// 判断对象是否为数组
export function isArrayFn(value) {
    if (typeof Array.isArray === "function") {
        return Array.isArray(value);
    } else {
        return Object.prototype.toString.call(value) === "[object Array]";
    }
}

export function isObj(value) {
    return Object.prototype.toString.call(value) === "[object Object]";
}

// 获取年月日
export function getDate(time) {
    let myDate = new Date(time);
    let year = myDate.getFullYear();
    let month = myDate.getMonth() + 1;
    month = month > 9 ? month : `0${month}`;
    let date = myDate.getDate();
    date = date > 9 ? date : `0${date}`;
    return year + "-" + month + "-" + date;
}

// 获取年月日时分
export function getfullTime(time) {
    let myDate = new Date(time);
    let year = myDate.getFullYear();
    let month = myDate.getMonth() + 1;
    month = month > 9 ? month : `0${month}`;
    let date = myDate.getDate();
    date = date > 9 ? date : `0${date}`;
    let HH = myDate.getHours();
    let min = myDate.getMinutes();
    return year + "-" + month + "-" + date + " " + HH + ":" + min;
}

// 人政策状态枚举
export function policyEnume(state) {
    switch (state) {
        case 0:
            return { text: "待审核", color: "#0687D2" };
        case 1:
            return { text: "待复审", color: "#0687D2" };
        case 2:
            return { text: "待终审", color: "#0687D2" };
        case 3:
            return { text: "已完结", color: "#36D91F" };
        case 4:
            return { text: "已驳回", color: "#EB4E3F" };
        case 5:
            return { text: "已撤销", color: "#999999" };
        case 6:
            return { text: "资料审核", color: "#0687D2" };
        case 7:
            return { text: "发放补贴", color: "#0687D2" };
        default:
            return { text: "未知状态", color: "#999999" };
    }
}