// import { request, config } from '@/utils/request'
import { request2, config2 } from '@/utils/axios'

/**
 * 上传照片文件
 * @param {Object} data
 */
export function uploadFile(data) {
    return request2({
        // headers: { 
        //     "Content-Type": "multipart/form-data",
        //     "Authorization": "Bearer " + sessionStorage.getItem("token") 
        // },
        url: `${config2.baseUrl}app-api/file/DeedTaxUpload`,
        method: 'post',
        data: data
    })
}

/**
 * 契税补贴申请列表
 */
export function queryListDeedTaxInfoByUserId(data) {
    return request2({
        url: `${config2.baseUrl}app-api/deedTax/queryListDeedTaxInfoByUserId`,
        method: 'post',
        data: data
    })
}

/**
 * 契税补贴申请新增
 */
export function addDeedTax(data) {
    return request2({
        url: `${config2.baseUrl}app-api/deedTax/addDeedTax`,
        method: 'post',
        data: data
    })
}

/**
 * 契税补贴初审审核意见
 */
export function queryReviewerDeedTaxRecord(data) {
    return request2({
        url: `${config2.baseUrl}app-api/deedTax/queryReviewerDeedTaxRecord`,
        method: 'post',
        data: data
    })
}

/**
 * 契税补贴审核意见
 */
export function queryDeedTaxRecord(data) {
    return request2({
        url: `${config2.baseUrl}app-api/deedTax/queryDeedTaxRecord`,
        method: 'post',
        data: data
    })
}

/**
 * 契税补贴查询详情
 */
export function queryDeedTaxInfoByCode(data) {
    return request2({
        url: `${config2.baseUrl}app-api/deedTax/queryDeedTaxInfoByCode`,
        method: 'post',
        data: data
    })
}

/**
 * 契税补贴申请修改
 */
export function updateDeedTax(data) {
    return request2({
        url: `${config2.baseUrl}app-api/deedTax/updateDeedTax`,
        method: 'post',
        data: data
    })
}

/**
 * 银行卡确认
 */
export function updateDeedTaxState(data) {
    return request2({
        url: `${config2.baseUrl}app-api/deedTax/updateDeedTaxState`,
        method: 'post',
        data: data
    })
}

/**
 * 查询用户申请记录
 */
export function queryUserApplyForRecord(data) {
    return request2({
        url: `${config2.baseUrl}app-api/deedTax/queryUserApplyForRecord`,
        method: 'post',
        data: data
    })
}

/**
 * 查询用户申请中的详细信息
 */
export function queryApplyingDeedTaxInfo(data) {
    return request2({
        url: `${config2.baseUrl}app-api/deedTax/queryApplyingDeedTaxInfo`,
        method: 'post',
        data: data
    })
}

/**
 * 身份证验重（判断用户是否享受过相关政策）
 */
 export function idCardVerification(data) {
    return request2({
        url: `${config2.baseUrl}app-api/deedTax/idCardVerification`,
        method: 'post',
        data: data
    })
}