import axios from 'axios'
import { mapKey } from '@/config/index'

/**
 * 逆地址解析
 * @param { point: 'lat<纬度>,lng<经度>' } data
 * @returns
 */
export const getGeocoder = (point) => {
  const params = {
    location: point || '32.188478,119.425722',
    get_poi: '1',
    key: mapKey.key
  }
  return axios.get('/baiduapi/ws/geocoder/v1/', {
    params: {
      ...params
    }
  })
}

/**
 * 根据城市/区域搜索
 * @param { string } str
 * @returns
 */
export const searchArea = (str) => {
  const params = {
    keyword: encodeURI(str),
    page_size: 20,
    key: mapKey.key,
    boundary: 'region(镇江,0)'
  }
  return axios.get('/baiduapi/ws/place/v1/search', {
    params: params
  })
}

/**
 * 百度坐标转换成经纬度
 * @param { string } str
 * @returns
 */
export const zhuanhuan = (str) => {
  const params = {
    locations: str,
    type: 3,
    key: mapKey.key
  }
  return axios.get('/baiduapi/ws/coord/v1/translate', { params })
}

/**
 * 高德gpi转换
 * @param {`lng,lat`} str  坐标点,经度和纬度用“,”分割，经度在前，纬度在后
 * @returns
 */
export const gaoDeZhuanHuan = (str) => {
  const params = {
    locations: str,
    coordsys: 'baidu'
  }
  return axios.get('/gaodeapi/v3/assistant/coordinate/convert', {
    params
  })
}
