import Vue from "vue";
import VueRouter from "vue-router";
import basicLayout from "@/layout/basicLayout";

Vue.use(VueRouter);

const routes = [
  // 冷链食品出入库
  {
    path: "/coldfood",
    name: "ColdFood",
    component: basicLayout,
    redirect: "/coldfood/index",
    children: [
      {
        path: "index",
        name: "Index",
        component: () => import("@/views/coldfood/"),
        meta: {
          title: "冷链食品申报",
        },
      },
      {
        path: "manage",
        name: "Manage",
        component: () => import("@/views/coldfood/manageIndex"),
        meta: {
          title: "冷链食品申报",
        },
      },
      {
        path: "report",
        name: "Report",
        component: () => import("@/views/coldfood/report"),
        meta: {
          title: "预约入库",
        },
      },
      {
        path: "selfreport",
        name: "SelfReport",
        component: () => import("@/views/coldfood/selfreport"),
        meta: {
          title: "自主信息录入",
        },
      },
      {
        path: "myreport",
        name: "MyReport",
        component: () => import("@/views/coldfood/myReport"),
        meta: {
          title: "我的预约",
        },
      },
      {
        path: "reportdetail",
        name: "MyReportDetail",
        component: () => import("@/views/coldfood/myReportDetail"),
        meta: {
          title: "预约详情",
        },
      },
      {
        path: "password",
        name: "Password",
        component: () => import("@/views/coldfood/password"),
        meta: {
          title: "口令鉴定",
        },
      },
      {
        path: "comein",
        name: "ComeIn",
        component: () => import("@/views/coldfood/comeIn"),
        meta: {
          title: "冷链食品出入库",
        },
      },
      {
        path: "check",
        name: "Check",
        component: () => import("@/views/coldfood/check"),
        meta: {
          title: "消杀、检测、灭活管理",
        },
      },
      {
        path: "slefreportdetail",
        name: "SlefReportDetail",
        component: () => import("@/views/coldfood/selfReportDetail"),
        meta: {
          title: "自主申报详情",
        },
      },
      {
        path: "review",
        name: "Review",
        component: () => import("@/views/coldfood/review"),
        meta: {
          title: "货物流向追溯",
        },
      },
      {
        path: "addtrace",
        name: "AddTrace",
        component: () => import("@/views/coldfood/addTrace"),
        meta: {
          title: "添加货物流向追溯",
        },
      },
    ],
  },
  // 公共服务电话
  {
    path: "/phone",
    name: "Phone",
    component: basicLayout,
    redirect: "/phone/index",
    children: [
      {
        path: "index",
        name: "PhoneIndex",
        component: () => import("@/views/phone/"),
        meta: {
          title: "公共服务电话",
        },
      },
    ],
  },
  // 公安便民服务
  {
    path: "/convenience",
    name: "Convenience",
    component: () => import("@/views/convenience"),
    meta: {
      title: "公安便民服务",
    },
  },
  {
    path: "/convenienceCopy",
    name: "ConvenienceCopy",
    component: () => import("@/views/convenienceCopy"),
    meta: {
      title: "公安便民服务",
    },
  },
  // 便民通知
  {
    path: "/notice",
    name: "Notice",
    component: basicLayout,
    redirect: "/notice/index",
    children: [
      {
        path: "index",
        name: "NoticeIndex",
        component: () => import("@/views/noticeservice/"),
        meta: {
          title: "便民通知",
        },
      },
      {
        path: "detail",
        name: "NoticeDetail",
        component: () => import("@/views/noticeservice/detail"),
        meta: {
          title: "便民通知详情",
        },
      },
    ],
  },
  // 通知
  {
    path: "/opinion",
    name: "Opinion",
    component: basicLayout,
    redirect: "/opinion/index",
    children: [
      {
        path: "index",
        name: "opinionIndex",
        component: () => import("@/views/opinion/"),
        meta: {
          title: "镇江企业安全复工须知",
        },
      },
    ],
  },
  {
    path: "/special",
    name: "Special",
    component: () => import("@/views/special/"),
    meta: {
      title: "红色专窗",
    },
  },
  {
    path: "/aedmap",
    name: "Aedmap",
    component: basicLayout,
    redirect: "/aedmap/index",
    children: [
      {
        path: "index",
        name: "AedmapIndex",
        component: () => import("@/views/aedmap/index.vue"),
        meta: {
          title: "AED急救",
        },
      },
      {
        path: "introduce",
        name: "AedmapIntroduce",
        component: () => import("@/views/aedmap/introduce"),
        meta: {
          title: "AED介绍",
        },
      },
      {
        path: "explain",
        name: "AedmapExplain",
        component: () => import("@/views/aedmap/explain"),
        meta: {
          title: "AED免责说明",
        },
      },
    ],
  },
  {
    path: "/column",
    name: "Column",
    component: () => import("@/views/column/index.vue"),
    meta: {
      title: "",
    },
  },
  // 智慧人社
  {
    path: "/insurance",
    name: "Insurance",
    component: basicLayout,
    redirect: "/insurance/index",
    children: [
      {
        path: "index",
        name: "InsuranceIndex",
        component: () => import("@/views/insurance/"),
        meta: {
          title: "智慧人社",
        },
      },
      {
        path: "detail",
        name: "InsuranceDetail",
        component: () => import("@/views/insurance/detail"),
        meta: {
          title: "智慧人社详情",
        },
      },
      {
        path: "info",
        name: "InsuranceInfo",
        component: () => import("@/views/insurance/info"),
        meta: {
          title: "参保信息",
        },
      },
      {
        path: "card",
        name: "InsuranceCard",
        component: () => import("@/views/insurance/card"),
        meta: {
          title: "社保卡信息",
        },
      },
      {
        path: "budget",
        name: "InsuranceBudget",
        component: () => import("@/views/insurance/budget"),
        meta: {
          title: "养老收支查询",
        },
      },
      {
        path: "personal",
        name: "InsurancePersonal",
        component: () => import("@/views/insurance/personal"),
        meta: {
          title: "个人档案查询",
        },
      },
    ],
  },
  //供电服务
  {
    path: "/power",
    name: "Power",
    component: basicLayout,
    redirect: "/power/index",
    children: [
      {
        path: "index",
        name: "PowerIndex",
        component: () => import("@/views/power/"),
        meta: {
          title: "供电服务",
        },
      },
    ],
  },
  // 公积金
  {
    path: "/fund",
    name: "Fund",
    component: basicLayout,
    redirect: "/fund/index",
    children: [
      {
        path: "index",
        name: "FundIndex",
        component: () => import("@/views/fund/"),
        meta: {
          title: "公积金",
        },
      },
      {
        path: "card",
        name: "FundCard",
        component: () => import("@/views/fund/card"),
        meta: {
          title: "公积金缴纳信息",
        },
      },
      {
        path: "payment",
        name: "FundPayment",
        component: () => import("@/views/fund/payment"),
        meta: {
          title: "公积金缴纳明细",
        },
      },
      {
        path: "loaninfo",
        name: "FundLoanInfo",
        component: () => import("@/views/fund/loanInfo"),
        meta: {
          title: "公积金贷款信息",
        },
      },
      {
        path: "loandet",
        name: "FundLoanDetail",
        component: () => import("@/views/fund/loandet"),
        meta: {
          title: "公积金贷款还款明细",
        },
      },
    ],
  },
  // 政务服务
  {
    path: "/govservice",
    name: "GovService",
    component: basicLayout,
    redirect: "/govservice/index",
    children: [
      {
        path: "index",
        name: "GovServiceIndex",
        component: () => import("@/views/govservice/"),
        meta: {
          title: "在线预约",
        },
      },
      {
        path: "order",
        name: "GovServiceOrder",
        component: () => import("@/views/govservice/order"),
        meta: {
          title: "在线预约",
        },
      },
      {
        path: "task",
        name: "GovServiceTask",
        component: () => import("@/views/govservice/task"),
        meta: {
          title: "在线预约",
        },
      },
      {
        path: "add",
        name: "AddOrder",
        component: () => import("@/views/govservice/addOrder"),
        meta: {
          title: "选择预约时间",
        },
      },
    ],
  },
  // 低保申请
  {
    path: "/guarantee",
    name: "Guarantee",
    component: basicLayout,
    redirect: "/guarantee/index",
    children: [
      {
        path: "index",
        name: "GuaranteeIndex",
        component: () => import("@/views/guarantee/index"),
        meta: {
          title: "救助申请",
        },
      },
      {
        path: "situation",
        name: "GuaranteeSituation",
        component: () => import("@/views/guarantee/situation"),
        meta: {
          title: "申请概况",
        },
      },
      {
        path: "family",
        name: "GuaranteeFamily",
        component: () => import("@/views/guarantee/family"),
        meta: {
          title: "申请基本信息",
        },
      },
      {
        path: "verify",
        name: "GuaranteeVerify",
        component: () => import("@/views/guarantee/verify"),
        meta: {
          title: "授权核查列表",
        },
      },
    ],
  },
  // 公共资源采购
  {
    path: "/respurchase",
    name: "ResPurchase",
    component: basicLayout,
    redirect: "/respurchase/index",
    children: [
      {
        path: "index",
        name: "ResPurchaseIndex",
        component: () => import("@/views/respurchase/"),
        meta: {
          title: "公共资源采购",
        },
      },
      {
        path: "detail",
        name: "ResPurchaseDetail",
        component: () => import("@/views/respurchase/detail"),
        meta: {
          title: "公共资源采购详情",
        },
      },
    ],
  },
  // 人才码
  {
    path: "/talents",
    name: "Talents",
    component: basicLayout,
    redirect: "/talents/index",
    children: [
      {
        path: "index",
        name: "TalentsIndex",
        component: () => import("@/views/talents/"),
        meta: {
          title: "人才码",
        },
      },
      {
        path: "qrcode",
        name: "QRCode",
        component: () => import("@/views/talents/qrcode"),
        meta: {
          title: "人才码核验",
        },
      },
      {
        path: "rule",
        name: "TalentRule",
        component: () => import("@/views/talents/rule"),
        meta: {
          title: "人才码申报指南",
        },
      },
      {
        path: "report",
        name: "TalentReport",
        component: () => import("@/views/talents/report"),
        meta: {
          title: "人才码申报",
        },
      },
      {
        path: "reportform",
        name: "ReportForm",
        component: () => import("@/views/talents/reportform"),
        meta: {
          title: "人才码申报",
        },
      },
      {
        path: "reportfilter",
        name: "ReportFilter",
        component: () => import("@/views/talents/reportfilter"),
        meta: {
          title: "人才码申报",
        },
      },
      {
        path: "showinfo",
        name: "ShowInfo",
        component: () => import("@/views/talents/showinfo"),
        meta: {
          title: "人才码详情",
        },
      },
    ],
  },
  // 网捷贷
  {
    path: "/quickloans",
    name: "QuickLoans",
    component: basicLayout,
    redirect: "/quickloans/index",
    children: [
      {
        path: "index",
        name: "QuickLoansIndex",
        component: () => import("@/views/quickloans/"),
        meta: {
          title: "网捷贷",
        },
      },
      {
        path: "detail",
        name: "QuickLoansDetail",
        component: () => import("@/views/quickloans/detail"),
        meta: {
          title: "网捷贷详情",
        },
      },
      {
        path: "account",
        name: "Account",
        component: () => import("@/views/quickloans/account"),
        meta: {
          title: "对公开户",
        },
      },
    ],
  },
  // 人才政策
  {
    path: "/policy",
    name: "Policy",
    component: basicLayout,
    redirect: "/policy/index",
    children: [
      {
        path: "index",
        name: "PolicyIndex",
        component: () => import("@/views/policy/"),
        meta: {
          title: "人才政策",
        },
      },
      {
        path: "list",
        name: "PolicyList",
        component: () => import("@/views/policy/list"),
        meta: {
          title: "人才事项办理指南",
        },
      },
      {
        path: "detail",
        name: "PolicyDetail",
        component: () => import("@/views/policy/detail"),
        meta: {
          title: "人才事项办理指南",
        },
      },
      {
        path: "online",
        name: "PolicyOnline",
        component: () => import("@/views/policy/online"),
        meta: {
          title: "线上办理项",
        },
      },
      {
        path: "rule",
        name: "PolicyRule",
        component: () => import("@/views/policy/rule"),
        meta: {
          title: "人才政策申报指南",
        },
      },
      {
        path: "health-manage",
        name: "HealthManage",
        component: () => import("@/views/policy/healthmanage"),
        meta: {
          title: "健康管理服务指南",
        },
      },
      {
        path: "health-check",
        name: "HealthCheck",
        component: () => import("@/views/policy/healthcheck"),
        meta: {
          title: "健康体检指南",
        },
      },
      {
        path: "health-path",
        name: "HealthPath",
        component: () => import("@/views/policy/healthpath"),
        meta: {
          title: "绿色就医通道",
        },
      },
      {
        path: "policy-report-index",
        name: "PolicyReportIndex",
        component: () => import("@/views/policy/myreportIndex"),
        meta: {
          title: "我的申报",
        },
      },
      {
        path: "policy-report-one",
        name: "PolicyReportOne",
        component: () => import("@/views/policy/myreport"),
        meta: {
          title: "我的申报",
        },
      },
      {
        path: "policy-report-two",
        name: "PolicyReportTwo",
        component: () => import("@/views/policy/myreportTwo"),
        meta: {
          title: "我的申报",
        },
      },
      {
        path: "policy-report-three",
        name: "PolicyReportThree",
        component: () => import("@/views/policy/myreportThree"),
        meta: {
          title: "我的申报",
        },
      },
      {
        path: "care/careAED",
        name: "PolicyCare",
        component: () => import("@/views/policy/care/careAED"),
        meta: {
          title: "人才父母惠老关怀申请",
        },
      },
      // {
      //   path: 'care/elderlycare',
      //   name: 'PolicyCare',
      //   component: () => import('@/views/policy/care/elderlycare'),
      //   meta: {
      //     title: '人才父母惠老关怀申请'
      //   },
      // },
      {
        path: "house-purchase",
        name: "HousePurchase",
        component: () => import("@/views/policy/housepurchase"),
        meta: {
          title: "人才“镇兴”行动购住房契税补贴申请",
        },
      },

      // 购房补贴
      {
        path: "purchase/index",
        name: "PolicyPurchaseIndex",
        component: () => import("@/views/policy/purchase/index"),
        meta: {
          title: "购房补贴申领服务指南",
        },
      },
      {
        path: "purchase/indexedit",
        name: "PolicyPurchaseIndexedit",
        component: () => import("@/views/policy/purchase/indexedit"),
        meta: {
          title: "购房补贴申领服务指南",
        },
      },
      {
        path: "purchase/submit",
        name: "PolicyPurchaseSubmit",
        component: () => import("@/views/policy/purchase/submit"),
        meta: {
          title: "提交成功",
        },
      },
      {
        path: "purchase/enterprise",
        name: "PolicyPurchaseEnterprise",
        component: () => import("@/views/policy/purchase/enterprise"),
        meta: {
          title: "企业信息",
        },
      },
      {
        path: "purchase/enterpriseedit",
        name: "PolicyPurchaseEnterpriseedit",
        component: () => import("@/views/policy/purchase/enterpriseedit"),
        meta: {
          title: "企业信息",
        },
      },
      {
        path: "purchase/applicant",
        name: "PolicyPurchaseApplicant",
        component: () => import("@/views/policy/purchase/applicant"),
        meta: {
          title: "申请人信息",
        },
      },
      {
        path: "purchase/applidetail",
        name: "PolicyPurchaseApplidetail",
        component: () => import("@/views/policy/purchase/applidetail"),
        meta: {
          title: "申请人信息",
        },
      },
    ],
  },
  // 新契税补贴
  {
    path: "/deedtax",
    name: "Deedtax",
    component: basicLayout,
    redirect: "/deedtax/index",
    children: [
      {
        path: "detail",
        name: "DeedtaxDetail",
        component: () => import("@/views/deedtax/detail"),
        meta: {
          title: "契税补贴政策",
        },
      },
      {
        path: "index",
        name: "DeedtaxIndex",
        component: () => import("@/views/deedtax/"),
        meta: {
          title: "契税补贴",
        },
      },
      {
        path: "declare",
        name: "DeedtaxDeclare",
        component: () => import("@/views/deedtax/declare"),
        meta: {
          title: "契税补贴申报",
        },
      },
      {
        path: "declare",
        name: "DeedtaxDeclare1",
        component: () => import("@/views/deedtax/declare"),
        meta: {
          title: "信息确认",
        },
      },
      {
        path: "declared",
        name: "DeedtaxDeclared",
        component: () => import("@/views/deedtax/declared"),
        meta: {
          title: "申报成功",
        },
      },
      {
        path: "handling",
        name: "DeedtaxHandling",
        component: () => import("@/views/deedtax/handling"),
        meta: {
          title: "办理进度",
        },
      },
    ],
  },
  // extra
  {
    path: "/extra",
    name: "Extra",
    component: basicLayout,
    redirect: "/extra/index",
    children: [
      {
        path: "index",
        name: "ExtraIndex",
        component: () => import("@/views/extra/"),
        meta: {
          title: "测试",
        },
      },
      {
        path: "talentService",
        name: "TalentService",
        component: () => import("@/views/extra/talentService"),
        meta: {
          title: "一窗通办",
        },
      },
    ],
  },
  // 注销账号
  {
    path: "/cancellation",
    name: "Cancellation",
    component: basicLayout,
    redirect: "/cancellation/index",
    children: [
      {
        path: "index",
        name: "CancellationIndex",
        component: () => import("@/views/cancellation/index.vue"),
        meta: {
          title: "注销账号",
        },
      },
      {
        path: "confirmlogout",
        name: "CancellationConfirmlogout",
        component: () => import("@/views/cancellation/confirmlogout.vue"),
        meta: {
          title: "注销账号",
        },
      },
    ],
  },
  // 疫情信息
  {
    path: "/epidemic",
    name: "Epidemic",
    component: basicLayout,
    redirect: "/epidemic/index",
    children: [
      {
        path: "index",
        name: "EpidemicIndex",
        component: () => import("@/views/epidemic/index.vue"),
        meta: {
          title: "疫情信息",
        },
      },
      {
        path: "information",
        name: "EpidemicInformation",
        component: () => import("@/views/epidemic/information.vue"),
        meta: {
          title: "疫情信息",
        },
      },
    ],
  },
  // 扫码上报
  {
    path: "/report",
    name: "Report",
    component: basicLayout,
    redirect: "/report/index",
    children: [
      {
        path: "index",
        name: "ReportIndex",
        component: () => import("@/views/report/index.vue"),
        meta: {
          title: "扫码上报",
        },
      },
      {
        path: "myreport",
        name: "ReportMyReport",
        component: () => import("@/views/report/report.vue"),
        meta: {
          title: "个人出行登记",
        },
      },
      {
        path: "replacereport",
        name: "ReportReplacereport",
        component: () => import("@/views/report/replacereport.vue"),
        meta: {
          title: "代他人出行登记",
        },
      },
      {
        path: "gatreport",
        name: "ReportGatreport",
        component: () => import("@/views/report/gatreport.vue"),
        meta: {
          title: "港澳台及外籍用户登记",
        },
      },
      {
        path: "details",
        name: "ReportDetails",
        component: () => import("@/views/report/details.vue"),
        meta: {
          title: "上报成功",
        },
      },
      {
        path: "detail",
        name: "ReportDetail",
        component: () => import("@/views/report/detail.vue"),
        meta: {
          title: "扫码统计",
        },
      },
      {
        path: "health",
        name: "ReportHealth",
        component: () => import("@/views/report/health.vue"),
        meta: {
          title: "核酸检测结果查询",
        },
      },
      {
        path: "health1",
        name: "ReportHealth1",
        component: () => import("@/views/report/health1.vue"),
        meta: {
          title: "核酸检测结果查询",
        },
      },
      {
        path: "scancode",
        name: "ReportScancode",
        component: () => import("@/views/report/scancode.vue"),
        meta: {
          title: "扫一扫",
        },
      },
    ],
  },
  // 反向扫码上报行程
  {
    path: "/reverse",
    name: "Reverse",
    component: basicLayout,
    redirect: "/reverse/index",
    children: [
      {
        path: "index",
        name: "ReverseIndex",
        component: () => import("@/views/reverse/index.vue"),
        meta: {
          title: "镇江通行码",
        },
      },
      {
        path: "submit",
        name: "ReverseSubmit",
        component: () => import("@/views/reverse/submit.vue"),
        meta: {
          title: "个人通行码",
        },
      },
      {
        path: "grDetail",
        name: "ReverseGrDetail",
        component: () => import("@/views/reverse/grDetail.vue"),
        meta: {
          title: "个人通行码",
        },
      },
      {
        path: "jrList",
        name: "ReverseJrList",
        component: () => import("@/views/reverse/jrList.vue"),
        meta: {
          title: "家人通行码",
        },
      },
      {
        path: "staff",
        name: "ReverseStaff",
        component: () => import("@/views/reverse/staff.vue"),
        meta: {
          title: "员工授权",
        },
      },
      {
        path: "apply",
        name: "ReverseApply",
        component: () => import("@/views/reverse/apply.vue"),
        meta: {
          title: "扫码权限申请",
        },
      },
      {
        path: "register",
        name: "ReverseRegister",
        component: () => import("@/views/reverse/register.vue"),
        meta: {
          title: "入场登记",
        },
      },
    ],
  },
  // 防范诈骗
  {
    path: "/noswindle",
    name: "Noswindle",
    component: basicLayout,
    redirect: "/noswindle/index",
    children: [
      {
        path: "index",
        name: "NoswindleIndex",
        component: () => import("@/views/noswindle/index.vue"),
        meta: {
          title: "防范诈骗",
        },
      },
    ],
  },
  // 生成通行码
  {
    path: "/current",
    name: "Current",
    component: basicLayout,
    redirect: "/current/index",
    children: [
      {
        path: "index",
        name: "CurrentIndex",
        component: () => import("@/views/current/index.vue"),
        meta: {
          title: "生成通行码",
        },
      },
      {
        path: "history",
        name: "CurrentHistory",
        component: () => import("@/views/current/history.vue"),
        meta: {
          title: "通行码历史数据",
        },
      },
      {
        path: "details",
        name: "CurrentDetails",
        component: () => import("@/views/current/details.vue"),
        meta: {
          title: "镇江通行码",
        },
      },
      {
        path: "map",
        name: "CurrentMap",
        component: () => import("@/views/current/map.vue"),
        meta: { title: "选择位置" },
      },
    ],
  },
  // zjtj
  {
    path: "/zjtj",
    name: "Zjtj",
    component: () => import("@/views/zjtj/"),
    meta: {
      title: "镇江统计",
    },
  },
  // kstb
  {
    path: "/kstb",
    name: "Kstb",
    component: () => import("@/views/kstb/"),
    meta: {
      title: "跨省通办手册",
    },
  },
  // dkjc
  {
    path: "/dkjc",
    name: "Dkjc",
    component: () => import("@/views/dkjc/"),
    meta: {
      title: "操作指南",
    },
  },
  // 燃气支付
  {
    path: "/rqfy",
    name: "Rqfy",
    component: basicLayout,
    redirect: "/rqfy/index",
    children: [
      {
        path: "index",
        name: "RqfyIndex",
        component: () => import("@/views/rqfy/index.vue"),
        meta: {
          title: "绑定用户",
        },
      },
      {
        path: "repair",
        name: "Repair",
        component: () => import("@/views/rqfy/repair.vue"),
        meta: {
          title: "预约维修",
        },
      },
      {
        path: "check",
        name: "Check1",
        component: () => import("@/views/rqfy/check.vue"),
    },
    // 镇江政策措施
    {
        path: "/measure",
        name: "Measure",
        component: () =>
            import ("@/views/measure/index"),
        meta: {
            title: "镇江政策措施",
        },
    },
    // 身份码
    {
        path: "/identity",
        name: "identity",
        component: () =>
            import ("@/views/identity/index"),
        meta: {
          title: "预约安检",
        },
      },
      {
        path: "fire",
        name: "Fire",
        component: () => import("@/views/rqfy/fire.vue"),
        meta: {
          title: "预约点火",
        },
      },
      {
        path: "recharge",
        name: "Recharge",
        component: () => import("@/views/rqfy/recharge.vue"),
        meta: {
          title: "充值缴费",
        },
      },
      {
        path: "payrecord",
        name: "Payrecord",
        component: () => import("@/views/rqfy/payrecord.vue"),
        meta: {
          title: "缴费记录",
        },
      },
      {
        path: "usermanage",
        name: "Usermanage",
        component: () => import("@/views/rqfy/usermanage.vue"),
        meta: {
          title: "用户管理",
        },
      },
      {
        path: "hrrq",
        name: "Hrrq",
        component: () => import("@/views/rqfy/hrrq.vue"),
        meta: {
          title: "华润燃气",
        },
      },
    ],
  },
  // 扶贫水果
  {
    path: "/fruit",
    name: "Fruit",
    component: basicLayout,
    redirect: "/fruit/index",
    children: [
      {
        path: "index",
        name: "FruitIndex",
        component: () => import("@/views/fruit/index.vue"),
        meta: {
          title: "扶贫水果",
        },
      },
      {
        path: "fruit1",
        name: "Fruit1",
        component: () => import("@/views/fruit/fruit1.vue"),
        meta: {
          title: "兑换券",
        },
      },
      {
        path: "fruit2",
        name: "Fruit2",
        component: () => import("@/views/fruit/fruit2.vue"),
        meta: {
          title: "兑换历史",
        },
      },
      {
        path: "fruit3",
        name: "Fruit3",
        component: () => import("@/views/fruit/fruit3.vue"),
        meta: {
          title: "提货明细",
        },
      },
      {
        path: "fruit4",
        name: "Fruit4",
        component: () => import("@/views/fruit/fruit4.vue"),
        meta: {
          title: "兑换券",
        },
      },
      {
        path: "fruit5",
        name: "Fruit5",
        component: () => import("@/views/fruit/fruit5.vue"),
        meta: {
          title: "兑换券",
        },
      },
      {
        path: "fruit6",
        name: "Fruit6",
        component: () => import("@/views/fruit/fruit6.vue"),
        meta: {
          title: "提货成功",
        },
      },
      {
        path: "fruit7",
        name: "Fruit7",
        component: () => import("@/views/fruit/fruit7.vue"),
        meta: {
          title: "提货明细",
        },
      },
      {
        path: "fruit8",
        name: "Fruit8",
        component: () => import("@/views/fruit/fruit8.vue"),
        meta: {
          title: "兑换成功",
        },
      },
      {
        path: "fruitDetail",
        name: "FruitDetail",
        component: () => import("@/views/fruit/fruitDetail.vue"),
        meta: {
          title: "领取记录",
        },
      },
      {
        path: "fruitCheck",
        name: "FruitCheck",
        component: () => import("@/views/fruit/fruitCheck.vue"),
        meta: {
          title: "核验统计",
        },
      },
    ],
  },
  // 镇享付
  {
    path: "/zhenxiangfu",
    name: "zhenxiangfu",
    component: () => import("@/views/zhenxiangfu/index"),
    meta: {
      title: "镇享付",
    },
  },
  // 新镇江资讯
  {
    path: "/consult",
    name: "consult",
    component: () => import("@/views/consult/index"),
    meta: {
      title: "镇江资讯",
    },
  },
  // 身份码
  {
    path: "/identity",
    name: "identity",
    component: () => import("@/views/identity/index"),
    meta: {
      title: "身份码",
    },
  },
  // 最美网格员
  {
    path: "/grid",
    name: "grid",
    component: () => import("@/views/grid/index"),
    meta: {
      title: "最美网格员",
    },
  },
  // 判断版本进入新or旧页面
  {
    path: "/version",
    name: "version",
    component: () => import("@/views/version/index.vue"),
    meta: {
      title: "镇合意",
    },
  },
  // 跳转小程序
  {
    path: "/applets",
    name: "applets",
    component: () => import("@/views/applets/index"),
    meta: {
      title: "镇合意",
    },
  },
  // 互助倡议书
  {
    path: "/mutualaid",
    name: "mutualaid",
    component: () => import("@/views/mutualaid/index"),
    meta: {
      title: "互助倡议书",
    },
  },
  // 临时页面
  {
    path: "/temp",
    name: "temp",
    component: () => import("@/views/tempHtml/temp"),
    meta: {
      title: "镇合意",
    },
  },
  {
    path: "/answer",
    name: "answer",
    component: () => import("@/views/answer/index"),
    meta: {
      title: "答题",
    },
}
];

const router = new VueRouter({
  mode: "hash",
  base: process.env.BASE_URL,
  routes,
});

export default router;
