import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from './store'
import 'amfe-flexible'
import '@/styles/reset.css'
import BaiduMap from 'vue-baidu-map'
import BMapGL from 'BMapGL'

import Dayjs from 'dayjs'

// import eventBus from '@/eventBus/index'
Vue.prototype.$eventBus = new Vue()
Vue.prototype.$dayjs = Dayjs
let getAddressByPoint = function (data) {
  let geo = new BMapGL.Geocoder();
  geo.getLocation(new BMapGL.Point(data.lng, data.lat), function (result) {
    // alert(JSON.stringify(result))
    if (result) {
      // alert(JSON.stringify(result))
      Vue.prototype.$eventBus.$emit("getAddress", { address: result.surroundingPois[0].title, lng: data.lng, lat: data.lat })
    } else {
      Vue.prototype.$eventBus.$emit("getAddress", false)
    }
  });
}

Vue.prototype.$getAddressByPoint = getAddressByPoint
window.receiveLocation = function (data) {
  // alert(data)
  const value = JSON.parse(data);
  if (value.code == 0) {
    // 根据坐标得到地址描述    
    getAddressByPoint(value.data)
  } else {
    Vue.prototype.$eventBus.$emit("getAddress", false, value.msg)
  }
}

import {
  Toast,
  Dialog
} from 'vant'
Vue.use(BaiduMap, {
  ak: '59cPajA8jyyDtFjTgDfBMRNRsdmcsKeL'
})
Vue.use(Toast).use(Dialog)
Vue.config.productionTip = false
router.beforeEach((to, from, next) => {
  const browserHeaderTitle = to.meta.title;
  window.document.title = browserHeaderTitle
  next()
})

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app')