import { request, config } from '@/utils/request'
import { request2, config2 } from '@/utils/axios'

/**
 * 部门列表
 * @param {Object} data
 */
export function departmentList(data) {
  return request2({
    url: `${config2.baseUrl}app-api/talent/departmentList`,
    method: 'POST',
    data: data
  })
}

/**
 * 事项列表
 * @param {Object} data
 */
export function mattersList(data) {
  return request({
    url: `${config.baseUrl}talent/mattersList`,
    method: 'post',
    data: data
  })
}

/**
 * 查询列表才政策指南
 * @param {*} data 
 * @returns 
 */
export function mattersGuideList(data){
  return request2({
    url: `${config2.baseUrl}app-api/talent/mattersGuideList`,
    method: 'post',
    data: data
  })
}

/**
 * 事项详情
 */
export function mattersById(data) {
  return request({
    url: `${config.baseUrl}talent/mattersById`,
    method: 'post',
    data: data
  })
}

/**
 * 详情
 * @param {*} data 
 * @returns 
 */
export function mattersGuideGet(data) {
  return request2({
    url: `${config2.baseUrl}app-api/talent/mattersGuideGet`,
    method: 'post',
    data: data
  })
}

/**
 * 查询报名条件
 */
export function mattersByUserId(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersByUserId`,
    method: 'post',
    data: data
  })
}

/**
 * 健康管理指南申报
 */
export function mattersHealthyAdd(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersHealthyAdd`,
    method: 'post',
    data: data
  })
}

/**
 * 健康管理指南申报修改
 */
export function mattersHealthyUpdate(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersHealthyUpdate`,
    method: 'post',
    data: data
  })
}

/**
 * 健康体检申报
 */
export function mattersInspectAdd(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersInspectAdd`,
    method: 'post',
    data: data
  })
}

/**
 * 健康体检修改
 */
 export function mattersInspectUpdate(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersInspectUpdate`,
    method: 'post',
    data: data
  })
}


/**
 * 绿色就医通道申报
 */
 export function mattersGreenAdd(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersGreenAdd`,
    method: 'post',
    data: data
  })
}

/**
 * 绿色就医通道修改
 */
 export function mattersGreenUpdate(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersGreenUpdate`,
    method: 'post',
    data: data
  })
}

/**
 * 我的申报列表
 */
export function mattersByUserIdList(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersByUserIdList`,
    method: 'post',
    data: data
  })
}

/**
 * 申报详情
 */
export function mattersGet(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersGet`,
    method: 'post',
    data: data
  })
}

/**
 * 修改申报单状态
 */
 export function mattersUpdateState(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersUpdateState`,
    method: 'post',
    data: data
  })
}

/**
 * 预约医院列表
 */
 export function mattersHospitalList(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersHospitalList`,
    method: 'post',
    data: data
  })
}

/**
 * 惠老关怀添加
 * @param {*} data 
 * @returns 
 */
export function mattersParentAdd(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersParentAdd`,
    method: 'post',
    data: data
  })
}

/**
 * 惠老关怀修改
 * @param {*} data 
 * @returns 
 */
 export function mattersParentUpdate(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersParentUpdate`,
    method: 'post',
    data: data
  })
}

/**
 * 住房契税补贴添加
 * @param {*} data 
 * @returns 
 */
 export function mattersHousingAdd(data) {
  return request2({
    url: `${config2.baseUrl}app-api/housing/mattersHousingAdd`,
    method: 'post',
    data: data
  })
}

/**
 * 住房契税补贴我的申报列表
 */
 export function mattersHousingList(data) {
  return request2({
    url: `${config2.baseUrl}app-api/housing/mattersHousingList`,
    method: 'post',
    data: data
  })
}


/**
 * 住房契税补贴申报详情
 */
 export function mattersHousingGet(data) {
  return request2({
    url: `${config2.baseUrl}app-api/housing/mattersHousingGet`,
    method: 'post',
    data: data
  })
}

/**
 * 住房契税补贴申报更新
 */
 export function mattersHousingUpdate(data) {
  return request2({
    url: `${config2.baseUrl}app-api/housing/mattersHousingUpdate`,
    method: 'post',
    data: data
  })
}

/**
 * 住房契税补贴申报状态修改
 */
 export function mattersHousingUpdateState(data) {
  return request2({
    url: `${config2.baseUrl}app-api/housing/mattersHousingUpdateState`,
    method: 'post',
    data: data
  })
}

export function mattersArea(data) {
  return request({
    url: `${config.baseUrl}talent/mattersArea`,
    method: 'post',
    data: data
  })
}
// 判断是否满足惠老关怀追加
export function isParentState(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersSuperAdditionParentState`,
    method: 'post',
    data: data
  })
}

// 父母惠老关怀追加
export function mattersSuperAdditionParent(data) {
  return request2({
    url: `${config2.baseUrl}app-api/healthy/mattersSuperAdditionParent`,
    method: 'post',
    data: data
  })
}

// 购房补贴保存信息查询
export function mattersHouseUnSubmitGet(data) {
  return request({
    url: `${config.baseUrl}talentMatters/mattersHouseUnSubmitGet`,
    method: 'post',
    data: data
  })
}

// 购房补贴企业信息查询
export function queryMattersEnterpriseHouse(data) {
  return request({
    url: `${config.baseUrl}talentMatters/queryMattersEnterpriseHouse`,
    method: 'post',
    data: data
  })
}

// 购房补贴企业信息保存
export function saveMattersEnterpriseHouse(data) {
  return request({
    url: `${config.baseUrl}talentMatters/saveMattersEnterpriseHouse`,
    method: 'post',
    data: data
  })
}

// 购房补贴初始化员工列表
export function queryMattersListStaffHouse(data) {
  return request({
    url: `${config.baseUrl}talentMatters/queryMattersListStaffHouse`,
    method: 'post',
    data: data
  })
}

// 购房补贴初始化员工信息查询
export function queryMattersStaffHouse(params) {
  return request({
    url: `${config.baseUrl}talentMatters/queryMattersStaffHouse`,
    method: 'get',
    params: params
  })
}

// 购房补贴初始化员工信息修改
export function updateMattersStaffHouse(data) {
  return request({
    url: `${config.baseUrl}talentMatters/updateMattersStaffHouse`,
    method: 'post',
    data: data
  })
}

// 购房补贴初始化员工信息新增
export function saveMattersStaffHouse(data) {
  return request({
    url: `${config.baseUrl}talentMatters/saveMattersStaffHouse`,
    method: 'post',
    data: data
  })
}

// 购房补贴初始化员工信息删除
export function deleteMattersStaffHouse(params) {
  return request({
    url: `${config.baseUrl}talentMatters/deleteMattersStaffHouse`,
    method: 'get',
    params: params
  })
}

// 购房补贴初始化提交
export function addMattersHouse(data) {
  return request({
    url: `${config.baseUrl}talentMatters/addMattersHouse`,
    method: 'post',
    data: data
  })
}

// 购房补贴申请根据用户id查询列表
export function mattersHouseList(data) {
  return request({
    url: `${config.baseUrl}talentMatters/mattersHouseList`,
    method: 'post',
    data: data
  })
}

// 购房补贴申请用户自主撤销
export function mattersHouseUpdateState(data) {
  return request({
    url: `${config.baseUrl}talentMatters/mattersHouseUpdateState`,
    method: 'post',
    data: data
  })
}

// 购房补贴员工和企业驳回详情
export function mattersHouseRejectDetails(data) {
  return request({
    url: `${config.baseUrl}talentMatters/mattersHouseRejectDetails`,
    method: 'post',
    data: data
  })
}

// 购房补贴企业驳回详情
export function mattersHouseRejectEnterprise(data) {
  return request({
    url: `${config.baseUrl}talentMatters/mattersHouseRejectEnterprise`,
    method: 'post',
    data: data
  })
}

// 购房补贴企业驳回修改
export function mattersHouseRejectEnterpriseUpdate(data) {
  return request({
    url: `${config.baseUrl}talentMatters/mattersHouseRejectEnterpriseUpdate`,
    method: 'post',
    data: data
  })
}

// 购房补贴重新提交修改
export function mattersHouseUpdate(data) {
  return request({
    url: `${config.baseUrl}talentMatters/mattersHouseUpdate`,
    method: 'post',
    data: data
  })
}

// 购房补贴员工驳回列表
export function mattersHouseRejectStaffList(data) {
  return request({
    url: `${config.baseUrl}talentMatters/mattersHouseRejectStaffList`,
    method: 'post',
    data: data
  })
}

// 购房补贴员工驳回详情
export function mattersHouseRejectStaffInfo(params) {
  return request({
    url: `${config.baseUrl}talentMatters/mattersHouseRejectStaffInfo`,
    method: 'get',
    params: params
  })
}

// 购房补贴员工驳回修改
export function mattersHouseRejectStaffUpdate(data) {
  return request({
    url: `${config.baseUrl}talentMatters/mattersHouseRejectStaffUpdate`,
    method: 'post',
    data: data
  })
}

// 购房补贴员工人才类型
export function mattersHouseTalentType(params) {
  return request({
    url: `${config.baseUrl}talentMatters/mattersHouseTalentType`,
    method: 'get',
    params: params
  })
}