import { request, config } from '@/utils/request'

/**
 * 救助申请页面结果查询
 * @param {Object} data
 */
export function getList(data) {
  return request({
    url: `${config.baseUrl}allowance/getList`,
    method: 'post',
    data: data
  })
}

/**
 * 申请个人信息提交
 * @param {Object} data
 */
export function personalAdd(data) {
  return request({
    url: `${config.baseUrl}allowance/personalAdd`,
    method: 'post',
    data: data
  })
}

/**
 * 申请个人信息修改
 * @param {Object} data
 */
export function personalUpdate(data) {
  return request({
    url: `${config.baseUrl}allowance/personalUpdate`,
    method: 'post',
    data: data
  })
}

/**
 * 修改人脸核查状态
 */
export function updateFace(data) {
  return request({
    url: `${config.baseUrl}allowance/updateFace`,
    method: 'post',
    params: data
  })
}

/**
 * 申请单的状态详情
 * @param {Object} data 
 */
export function getStatistics(data) {
  return request({
    url: `${config.baseUrl}allowance/getStatistics`,
    method: 'post',
    data: data
  })
}

/**
 * 查询个人和家庭成员人脸核查进度
 * @param {Object} data 
 */
export function getCheckList(data) {
  return request({
    url: `${config.baseUrl}allowance/getCheckList`,
    method: 'post',
    data: data
  })
}

/**
 * 地区
 * @param {Object} data
 */
export function getArea(data) {
  return request({
    url: `${config.baseUrl}allowance/getArea`,
    method: 'get',
    params: data
  })
}

/**
 * 申请详情
 * @param {Object} data
 */
export function getPersonal(data) {
  return request({
    url: `${config.baseUrl}allowance/getPersonal`,
    method: 'post',
    data: data
  })
}