import { request, config, formatUrl } from '@/utils/request'

/**
 * 获取预约分类部门
 */
export function getDepartment(data) {
  return request({
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    url: `${config.baseServiceUrl}zjqueueAppointment/getCategoryAndOuListnew${formatUrl(data)}`,
    method: 'post',
    data
  })
}

/**
 * 获取今天预约列表
 */
export function getOrderList(data) {
  return request({
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    url: `${config.baseServiceUrl}zjqueueAppointment/getAppointListnew${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 获取预约事项列表
 */
export function getTaskList(data) {
  return request({
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    url: `${config.baseServiceUrl}zjqueueAppointment/getAppointTaskListnew${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 获取预约事项所在中心
 */
export function getCenter(data) {
  return request({
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    url: `${config.baseServiceUrl}zjqueueAppointment/getAppointCenternew${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 获取预约事项可预约日期
 */
export function getDate(data) {
  return request({
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    url: `${config.baseServiceUrl}zjqueueAppointment/getAppointDatenew${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 获取预约事项可预约时间
 */
export function getTime(data) {
  return request({
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    url: `${config.baseServiceUrl}zjqueueAppointment/getAppointTimenew${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 预约
 */
export function order(data) {
  return request({
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    url: `${config.baseServiceUrl}zjqueueAppointment/getAppointQnonew${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}

/**
 * 预约取消
 */
export function orderCancle(data) {
  return request({
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    url: `${config.baseServiceUrl}zjqueueAppointment/deleteAppointnew${formatUrl(data)}`,
    method: 'post',
    data: data
  })
}