// import { config,request } from '@/utils/request'
import { config,request } from '@/utils/request'
import { request2, config2 } from '@/utils/axios'

/**
 * 疫情区域
 */
export function epidemicArea(data){
    return request2({
        url: `${config2.baseUrl}app-api/epidemic/epidemicArea`,
        method: 'post',
        data: data
    })
}

/**
 * 疫情上报
 */
 export function epidemicUpload(data){
     return request2({
        url: `${config2.baseUrl}app-api/epidemic/epidemicUpload`,
        method: 'post',
        data: data
    })
}

/**
 * 图片上传
 */
export function fileUpload(data) {
    return request2({
        headers: { "Content-Type": "multipart/form-data" },
      //   url: `${config.baseUrl}file/ExportTransportationUpload`, //minio溢出
      //   url: `${config.baseUrl}file/fileUpload`,
        url: `${config2.baseUrl}app-api/file/ExportTransportationUpload`, //minio溢出
        method: 'post',
        data: data       
    })
}

/**
 * 扫码上报
 */
 export function epidemicQuickMarkUpload(data){
    return request({
       url: `${config.baseUrl}epidemic/epidemicQuickMarkUpload`,
       method: 'post',
       data: data
   })
}

/**
 * 通行码
 */
 export function permitCode(data){
    return request2({
       url: `${config2.baseUrl}app-api/epidemic/permitCode`,
       method: 'post',
       data: data
   })
}

/**
 * 通行码历史数据查询
 */
 export function queryOldListPermitCode(data){
   return request2({
      url: `${config2.baseUrl}app-api/epidemic/queryOldListPermitCode`,
      method: 'get',
      data: data
  })
}

/**
 * 统计扫码通行码的次数
 */
 export function addPermitStatistics(data){
    return request2({
       url: `${config2.baseUrl}app-api/epidemic/addPermitStatistics`,
       method: 'post',
       data: data
   })
}

/**
 * 存储用户信息
 */
 export function saveCacheUser(data){
    return request2({
       url: `${config2.baseUrl}app-api/epidemic/saveCacheUser`,
       method: 'post',
       data: data
   })
}

/**
 * 查询用户信息
 */
 export function queryCacheUser(data){
    return request2({
       url: `${config2.baseUrl}app-api/epidemic/queryCacheUser`,
       method: 'get',
       data: data
   })
}

/**
 * 是否为管理员
 */
 export function isManageUser(data){
    return request2({
       url: `${config2.baseUrl}app-api/epidemic/isManageUser?mobile=${data.mobile}`,
       method: 'get',
       data: data
   })
}

/**
 * 查询通行码扫码详情
 */
 export function queryPermitCodeInfo(data){
    return request2({
       url: `${config2.baseUrl}app-api/epidemic/queryPermitCodeInfo?permitCode=${data.permitCode}`,
       method: 'get',
       data: data
   })
}