// import { request1, config } from '@/utils/request'
import { request2, config2 } from '@/utils/axios'

/**
 * 查询本人通行码
 */
export function getOwn(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/queryOwnPermitCode`,
        method: 'get',
        params: data
    })
}

/**
 * 查询家人通行码
 */
export function getFamily(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/queryListFamilyPermitCode`,
        method: 'get',
        params: data
    })
}

/**
 * 上传照片文件
 * @param {Object} data
 */
export function uploadFile(data) {
    return request2({
        headers: { "Content-Type": "multipart/form-data" },
        url: `${config2.baseUrl}app-api/file/permitCodeUpload`,
        method: 'post',
        data: data
    })
}

/**
 * 添加个人通行码
 */
export function addUserPermitCode(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/addUserPermitCode`,
        method: 'post',
        data: data
    })
}

/**
 * 删除个人通行码
 */
export function delUserPermitCode(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/delUserPermitCode`,
        method: 'post',
        data: data
    })
}

/**
 * 修改个人通行码
 */
export function updateUserPermitCode(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/updateUserPermitCode`,
        method: 'post',
        data: data
    })
}

/**
 * 查询企业通行码
 */
export function queryListEnterprisePermitCode(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/queryListEnterprisePermitCode`,
        method: 'get',
        params: data
    })
}

/**
 * 查询通行码授权的员工信息
 */
export function queryListAuthUser(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/queryListAuthUser`,
        method: 'post',
        data: data
    })
}

/**
 * 查询通行码授权的员工信息
 */
export function addAuthUser(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/addAuthUser`,
        method: 'post',
        data: data
    })
}

/**
 * 删除授权的员工信息
 */
export function delAuthUser(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/delAuthUser`,
        method: 'post',
        data: data
    })
}

/**
 * 查询企业信息
 */
export function queryEnterpriseInfo(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/queryEnterpriseInfo`,
        method: 'get',
        params: data
    })
}

/**
 * 企业申请权限
 */
export function addEnterprise(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/addEnterprise`,
        method: 'post',
        data: data
    })
}

/**
 * 企业申请权限修改
 */
export function updateEnterprise(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/updateEnterprise`,
        method: 'post',
        data: data
    })
}

/**
 * 查询员工扫码权限
 */
export function queryStaffScanPower(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/queryStaffScanPower`,
        method: 'get',
        params: data
    })
}

/**
 * 查询通行码信息
 */
 export function queryUserPermitCodeInfo(data) {
    return request2({
        url: `${config2.baseUrl}app-api/permitCode/queryUserPermitCodeInfo`,
        method: 'get',
        params: data
    })
}