﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Netcore_Mysql.Models
{
    public class MyContext : DbContext
    {
        public DbSet<Contact> Contacts { get; set; }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            //Environment.SetEnvironmentVariable("Variable name", value);
            var service = Environment.GetEnvironmentVariable("MYSQL_SERVICE_NAME");
            var hostname = Environment.GetEnvironmentVariable($"{service.Replace('-', '_').ToUpper()}_SERVICE_HOST");
            var port = Environment.GetEnvironmentVariable($"{service.Replace('-', '_').ToUpper()}_SERVICE_PORT");
            var database = Environment.GetEnvironmentVariable("MYSQL_DATABASE");
            var username = Environment.GetEnvironmentVariable("MYSQL_USERNAME");
            var password = Environment.GetEnvironmentVariable("MYSQL_PASSWORD");
            optionsBuilder.UseMySql($"Server={hostname},{port};database={database};uid={username};pwd={password};");
        }

    }
}
