﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Netcore_Mysql.Models;

namespace Netcore_Mysql.Controllers
{
    public class HomeController : Controller
    {
        [HttpGet]
        public IActionResult Index()
        {
            var model = new IndexViewModel();
            using (var ctx = new MyContext())
            {
                model.ContactRecords = ctx.Contacts.OrderByDescending(v => v.SubmitOn).ToList();
            }
            return View(model);
        }

        [HttpPost]
        public IActionResult Index(IndexViewModel model)
        {
            using (var ctx = new MyContext())
            {
                model.Contact.SubmitOn = DateTime.Now;
                ctx.Contacts.Add(model.Contact);
                ctx.SaveChanges();
            }
            return RedirectToAction("Index");
        }

        public IActionResult Test()
        {
            return View();
        }
    }
}
