/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.thinkgem.jeesite.modules.youka.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.youka.entity.YoukaFeedback;
import com.thinkgem.jeesite.modules.youka.dao.YoukaFeedbackDao;

/**
 * 单表生成Service
 * @author tangting
 * @version 2018-06-20
 */
@Service
@Transactional(readOnly = true)
public class YoukaFeedbackService extends CrudService<YoukaFeedbackDao, YoukaFeedback> {

	public YoukaFeedback get(String id) {
		return super.get(id);
	}
	
	public List<YoukaFeedback> findList(YoukaFeedback youkaFeedback) {
		return super.findList(youkaFeedback);
	}
	
	public Page<YoukaFeedback> findPage(Page<YoukaFeedback> page, YoukaFeedback youkaFeedback) {
		Page<YoukaFeedback> pages = super.findPage(page, youkaFeedback);
		return pages;
	}
	
	@Transactional(readOnly = false)
	public void save(YoukaFeedback youkaFeedback) {
		super.save(youkaFeedback);
	}
	
	@Transactional(readOnly = false)
	public void delete(YoukaFeedback youkaFeedback) {
		super.delete(youkaFeedback);
	}
	
}