package com.thinkgem.jeesite.modules.youka.service;

import com.alibaba.fastjson.JSONObject;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.modules.youka.dto.CommonDto;
import com.thinkgem.jeesite.modules.youka.dto.QrCodeDto;
import com.thinkgem.jeesite.modules.youka.entity.YoukaRate;
import com.thinkgem.jeesite.modules.youka.utils.Bean2Map;
import com.thinkgem.jeesite.modules.youka.utils.JFenHttpUtil;
import com.thinkgem.jeesite.modules.youka.utils.MakeOrderNum;
import com.thinkgem.jeesite.modules.youka.utils.SignUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

/**
 * 首页通知
 */
@Service
@Transactional(readOnly = true)
public class JuHeZhongPayJFenService {
    private Logger logger = LoggerFactory.getLogger(Logger.class);



    /**
     * 商户入驻
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject merchantIn(JSONObject dto) throws Exception {
        dto.put("merchantId", ComCode.JFEN_MERCHANT_ID);
        dto.put("merchantKey", ComCode.JFEN_MERCHANT_KEY);
        String signBefore = SignUtils.signBefore(dto);
        logger.info("signBefore:{}", signBefore);
        String sign = SignUtils.sign(signBefore, ComCode.JFEN_MERCHANT_SECRET);
        dto.put("sign", sign);
        String respStr = JFenHttpUtil.postRaw(ComCode.HOST + ComCode.JFEN_MICRO_HANDLE_URL, dto.toString());
        return JSONObject.parseObject(respStr);
    }



    /**
     * 修改费率
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject merchantModifyFeel(JSONObject dto)throws Exception {
        dto.put("timestamp",System.currentTimeMillis());
        dto.put("serviceType","7");
        dto.put("orderId",MakeOrderNum.makeOrderNum());
        return merchantIn(dto);
    }

    /**
     * JuHeZhong支付用户费率
     * @param rateEntity
     * @return
     * @throws
     * @throws Exception
     */
    public void merchantFeelJFen(String subMchId, YoukaRate rateEntity) throws  Exception {
        // 修改费率
        JSONObject dto = new JSONObject();
        dto.put("subMchId",subMchId);
        dto.put("paymentType","QUICKPAY");
        dto.put("d0Fee",rateEntity.getRate());
        dto.put("d1Fee",rateEntity.getRate());
        JSONObject jsonObject = null;

        jsonObject = this.merchantModifyFeel(dto);


        if (!"0000".equals(jsonObject.getString("code"))) {

        }
    }

}
