/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.thinkgem.jeesite.modules.youka.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 单表生成Entity
 * @author tangting
 * @version 2018-06-20
 */
public class YoukaFeedback extends DataEntity<YoukaFeedback> {
	
	private static final long serialVersionUID = 1L;
	private String code;		// 唯一编码
	private String userCode;		// 反馈人code
	private String feedback;		// 反馈意见
	
	public YoukaFeedback() {
		super();
	}

	public YoukaFeedback(String id){
		super(id);
	}

	@Length(min=0, max=64, message="唯一编码长度必须介于 0 和 64 之间")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	@Length(min=0, max=64, message="反馈人code长度必须介于 0 和 64 之间")
	public String getUserCode() {
		return userCode;
	}

	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}
	
	public String getFeedback() {
		return feedback;
	}

	public void setFeedback(String feedback) {
		this.feedback = feedback;
	}
	
}