package com.thinkgem.jeesite.modules.youka.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class OrderEntity extends DataEntity<OrderEntity> implements Serializable {
    private String userCode; // 用户code
    private String payNo; // 订单号 4位年+2位月+2位日+2位时+2位分+8位随机数
    private String payCode; // 支付号
    private String payMethod;// 支付方式
    private String payChannel; // 支付渠道
    private String payStatus; // 订单状态 0待支付 1支付中 2已支付 3逾期取消
    private String amount; // 金额
    private String subject; // 商品名称
    private String tradeNo; // 交易号
    private String payType; // 交易类型 5借记卡 6贷记卡
    private String cardCode; // 支付卡code

    private String payChannelName;
    private String payMethodName;// 支付方式

    private Date createDate;

    private Date startTime;

    private Date endTime;

    private String code;

    private String benefitAmount; // 分润金额

    private String benefitDescribe;// 分润去向

    private String nickname;

    private String keywords;

    private List<YoukaBenefit> youkaBenefitList;

    public OrderEntity() {
    }

    @ExcelField(title = "创建时间", align = 2, sort = 25)
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }


    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getPayNo() {
        return payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    @ExcelField(title = "订单号", align = 2, sort = 20)
    public String getPayCode() {
        return payCode;
    }

    public void setPayCode(String payCode) {
        this.payCode = payCode;
    }

    public String getPayChannel() {
        return payChannel;
    }

    public void setPayChannel(String payChannel) {
        this.payChannel = payChannel;
    }

    @ExcelField(title = "支付状态", align = 2, sort = 50, dictType = "pay_status")
    public String getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    @ExcelField(title = "订单金额", align = 2, sort = 55)
    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getCardCode() {
        return cardCode;
    }

    public void setCardCode(String cardCode) {
        this.cardCode = cardCode;
    }

    @ExcelField(title = "支付渠道", align = 2, sort = 45)
    public String getPayChannelName() {
        return payChannelName;
    }

    public void setPayChannelName(String payChannelName) {
        this.payChannelName = payChannelName;
    }

    public String getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

    @ExcelField(title = "支付方式", align = 2, sort = 40)
    public String getPayMethodName() {
        return payMethodName;
    }

    public void setPayMethodName(String payMethodName) {
        this.payMethodName = payMethodName;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @ExcelField(title = "产生分润", align = 2, sort = 60)
    public String getBenefitAmount() {
        return benefitAmount;
    }

    public void setBenefitAmount(String benefitAmount) {
        this.benefitAmount = benefitAmount;
    }

    public List<YoukaBenefit> getYoukaBenefitList() {
        return youkaBenefitList;
    }

    public void setYoukaBenefitList(List<YoukaBenefit> youkaBenefitList) {
        this.youkaBenefitList = youkaBenefitList;
    }

    public String getBenefitDescribe() {
        return benefitDescribe;
    }

    @ExcelField(title = "分润去向", align = 2, sort = 65)
    public void setBenefitDescribe(String benefitDescribe) {
        this.benefitDescribe = benefitDescribe;
    }

    @ExcelField(title = "交易人", align = 2, sort = 30)
    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }
}
