/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.thinkgem.jeesite.modules.adv.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.adv.entity.YoukaAdv;
import com.thinkgem.jeesite.modules.adv.service.YoukaAdvService;

/**
 * 轮播图Controller
 * @author tangting
 * @version 2018-06-19
 */
@Controller
@RequestMapping(value = "${adminPath}/youka/adv")
public class YoukaAdvController extends BaseController {

	@Autowired
	private YoukaAdvService youkaAdvService;
	
	@ModelAttribute
	public YoukaAdv get(@RequestParam(required=false) String id) {
		YoukaAdv entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = youkaAdvService.get(id);
		}
		if (entity == null){
			entity = new YoukaAdv();
		}
		return entity;
	}
	
	@RequiresPermissions("youka:adv:view")
	@RequestMapping(value = {"list", ""})
	public String list(YoukaAdv youkaAdv, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<YoukaAdv> page = youkaAdvService.findPage(new Page<YoukaAdv>(request, response), youkaAdv); 
		model.addAttribute("page", page);
		return "modules/adv/advList";
	}

	@RequiresPermissions("youka:adv:view")
	@RequestMapping(value = "form")
	public String form(YoukaAdv youkaAdv, Model model) {
		model.addAttribute("youkaAdv", youkaAdv);
		return "modules/adv/advForm";
	}

	@RequiresPermissions("youka:adv:save")
	@RequestMapping(value = "save")
	public String save(YoukaAdv youkaAdv, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, youkaAdv)){
			return form(youkaAdv, model);
		}
		youkaAdvService.save(youkaAdv);
		addMessage(redirectAttributes, "保存轮播图成功");
		return "redirect:"+Global.getAdminPath()+"/youka/adv/list?repage";
	}
	
	@RequiresPermissions("youka:adv:save")
	@RequestMapping(value = "delete")
	public String delete(YoukaAdv youkaAdv, RedirectAttributes redirectAttributes) {
		youkaAdvService.update(youkaAdv);
		addMessage(redirectAttributes, "删除轮播图成功");
		return "redirect:"+Global.getAdminPath()+"/youka/adv/list?repage";
	}

}