/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.thinkgem.jeesite.modules.adv.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 轮播图Entity
 * @author tangting
 * @version 2018-06-19
 */
public class YoukaAdv extends DataEntity<YoukaAdv> {
	
	private String code;		// 唯一随机码
	private String type;		// 类型 WEB 网页链接  P-广告 HP-首页广告 W-网页链接  A-app轮播图
	private String title;		// 轮播图标题
	private String href;		// 链接 可以是相对路径也可以是绝对路径
	private String target;		// 目标 _blank _self _parent _top
	private String picture;		// 图片地址
	private String weight;		// 排序序号 倒序
	private String status;		// 状态 0 下线 1 上线 2 删除
	private String clicks;		// 点击数量
	private Date expireTime;		// 失效时间 0无失效时间 秒数
	private Date beginTime;		// 开始时间 0立即开始 秒数
	
	public YoukaAdv() {
	}

	public YoukaAdv(String code, String type, String title, String href, String target, String picture, String weight, String status, String clicks, Date expireTime, Date beginTime) {
		this.code = code;
		this.type = type;
		this.title = title;
		this.href = href;
		this.target = target;
		this.picture = picture;
		this.weight = weight;
		this.status = status;
		this.clicks = clicks;
		this.expireTime = expireTime;
		this.beginTime = beginTime;
	}

	@Length(min=1, max=200, message="唯一随机码长度必须介于 1 和 200 之间")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	@Length(min=1, max=100, message="类型 WEB 网页链接  P-广告 HP-首页广告 W-网页链接  A-app轮播图长度必须介于 1 和 100 之间")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	@Length(min=1, max=100, message="轮播图标题长度必须介于 1 和 100 之间")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	@Length(min=0, max=1024, message="链接 可以是相对路径也可以是绝对路径长度必须介于 0 和 1024 之间")
	public String getHref() {
		return href;
	}

	public void setHref(String href) {
		this.href = href;
	}
	
	@Length(min=0, max=20, message="目标 _blank _self _parent _top长度必须介于 0 和 20 之间")
	public String getTarget() {
		return target;
	}

	public void setTarget(String target) {
		this.target = target;
	}
	
	@Length(min=0, max=300, message="图片地址长度必须介于 0 和 300 之间")
	public String getPicture() {
		return picture;
	}

	public void setPicture(String picture) {
		this.picture = picture;
	}
	
	@Length(min=0, max=11, message="排序序号 倒序长度必须介于 0 和 11 之间")
	public String getWeight() {
		return weight;
	}

	public void setWeight(String weight) {
		this.weight = weight;
	}
	
	@Length(min=0, max=1, message="状态 0 下线 1 上线 2 删除长度必须介于 0 和 1 之间")
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}
	
	@Length(min=1, max=11, message="点击数量长度必须介于 1 和 11 之间")
	public String getClicks() {
		return clicks;
	}

	public void setClicks(String clicks) {
		this.clicks = clicks;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getExpireTime() {
		return expireTime;
	}

	public void setExpireTime(Date expireTime) {
		this.expireTime = expireTime;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(Date beginTime) {
		this.beginTime = beginTime;
	}
	
}