<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户列表</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出用户数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/youka/user/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"导入数据", buttons:{"关闭":true}, 
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
		});
		function page(n,s){
			if(n) $("#pageNo").val(n);
			if(s) $("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/youka/user/list");
			$("#searchForm").submit();
	    	return false;
	    }
	</script>
</head>
<body>
	<%--<div id="importBox" class="hide">--%>
		<%--<form id="importForm" action="${ctx}/youka/user/import" method="post" enctype="multipart/form-data"--%>
			<%--class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>--%>
			<%--<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　--%>
			<%--<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>--%>
			<%--<a href="${ctx}/youka/user/import/template">下载模板</a>--%>
		<%--</form>--%>
	<%--</div>--%>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/youka/user/list">用户列表</a></li>
		<shiro:hasPermission name="sys:user:edit"><li><a href="${ctx}/youka/user/form">用户添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="youkaUser" action="${ctx}/youka/user/list" method="post" class="breadcrumb form-search ">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<sys:tableSort id="orderBy" name="orderBy" value="${page.orderBy}" callback="page();"/>
		<ul class="ul-form">
			<li><label>用户名：</label><form:input path="nickname"></form:input></li>
			<li><label>用户类型：</label>
				<form:select path="level" cssStyle="width: 100px">
					<form:option value="">
						全部
					</form:option>
					<form:option value="S">
						管理员
					</form:option>
					<form:option value="A">
						王者会员
					</form:option>
					<form:option value="B">
						钻石会员
					</form:option>
					<form:option value="C">
						黄金会员
					</form:option>
					<form:option value="D">
						白银会员
					</form:option>
					<form:option value="E">
						青铜会员
					</form:option>
				</form:select></li>
			<%--<li class="clearfix"></li>--%>
			<li><label>认证状态：</label>
				<form:select path="status" cssStyle="width: 100px">
					<form:option value="">
						全部状态
					</form:option>
					<form:option value="0">
						未实名
					</form:option>
					<form:option value="1">
						审核中
					</form:option>
					<form:option value="2">
						已实名
					</form:option>
				</form:select>
			</li>
			<li><label>推荐人:</label><form:input path="recommendedMobile" htmlEscape="false" maxlength="50" class="input-medium"/></li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
				<%--<input id="btnExport" class="btn btn-primary" type="button" value="导出"/>--%>
				<%--<input id="btnImport" class="btn btn-primary" type="button" value="导入"/>--%>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead><tr><th>序号</th><th>用户名</th><th class="sort-column login_name">用户类型</th><th class="sort-column name">认证状态</th><th>手机号</th><th>归属</th><%--<th>角色</th> --%><shiro:hasPermission name="sys:user:edit"><th>操作</th></shiro:hasPermission></tr></thead>
		<tbody>
		<c:forEach items="${page.list}" var="user" varStatus="indexs">
			<tr>
				<td>${indexs.index}</td>
				<td>${user.nickname}</td>
				<td>
					<c:if test="${user.level eq 'S'}">管理员</c:if>
					<c:if test="${user.level eq 'A'}">王者会员</c:if>
					<c:if test="${user.level eq 'B'}">钻石会员</c:if>
					<c:if test="${user.level eq 'C'}">黄金会员</c:if>
					<c:if test="${user.level eq 'D'}">白银会员</c:if>
					<c:if test="${user.level eq 'E'}">青铜会员</c:if>
				</td>
				<td>
					<c:if test="${user.status eq '0'}">未实名</c:if>
					<c:if test="${user.status eq '1'}">审核中</c:if>
					<c:if test="${user.status eq '2'}">已实名</c:if>
				</td>
				<td>${user.mobile}</td>
				<td>
					<c:if test="${user.belongTo eq 'B'}">佰邦达</c:if>
					<c:if test="${user.belongTo eq 'S'}">盛世互通</c:if>
				</td><%--
				<td>${user.roleNames}</td> --%>
				<shiro:hasPermission name="sys:user:edit"><td>
    				<a href="${ctx}/youka/user/form?id=${user.id}">查看</a>
					<a href="${ctx}/youka/user/delete?id=${user.id}" onclick="return confirmx('确认要删除该用户吗？', this.href)">审核</a>
					<a href="${ctx}/youka/user/form?id=${user.id}">禁用</a>
					<a href="${ctx}/youka/user/form?id=${user.id}">账户明细</a>
					<a href="${ctx}/youka/user/form?id=${user.id}">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>