<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>文章管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

			$("#timing").click(function () {
				$("#sendDate").show();
            });
            $("#immediately").click(function () {
                $("#sendDate").hide();
            });
            if($("#link").val()){
                $('#linkBody').show();
                $('#url').attr("checked", true);
            }
			$("#title").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
                    if ($("#categoryId").val()==""){
                        $("#categoryName").focus();
                        top.$.jBox.tip('请选择归属栏目','warning');
                    }else if (CKEDITOR.instances.content.getData()=="" && $("#link").val().trim()==""){
                        top.$.jBox.tip('请填写正文','warning');
                    }else{
                        loading('正在提交，请稍等...');
                        form.submit();
                    }
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/cms/article/message/list?category.id=28">消息列表</a></li>
		<li class="active"><a href="<c:url value='${ctx}/cms/article/message/form?id=${article.id}&category.id=${article.category.id}'><c:param name='category.name' value='${article.category.name}'/></c:url>">消息<shiro:hasPermission name="cms:article:edit">${not empty article.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="cms:article:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="article" action="${ctx}/cms/article/message/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">主题:</label>
			<div class="controls">
				<form:input path="title" htmlEscape="false" maxlength="200" class="input-xxlarge measure-input required"/>
				&nbsp;
				<c:if test="${article.isTip eq 1}">
					<form:checkbox path="isTip" value="1" checked="checked"/>
				</c:if>
				<c:if test="${article.isTip ne 1}">
					<form:checkbox path="isTip" value="1"/>
				</c:if>
				同步到首页弹窗
				<c:if test="${article.isFlow eq 1}">
					<form:checkbox path="isFlow" value="1" checked="checked"/>
				</c:if>
				<c:if test="${article.isFlow ne 1}">
					<form:checkbox path="isFlow" value="1"/>
				</c:if>同步到首页滚动新闻

				<form:input path="category.id" value="28" cssStyle="display: none"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">内容:</label>
			<div class="controls">
				<form:textarea id="content" htmlEscape="true" path="articleData.content" rows="4" maxlength="200" class="input-xxlarge"/>
				<sys:ckeditor replace="content" uploadPath="/cms/article" />
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">推送范围:</label>
			<div class="controls">
				<%--<form:checkbox path="scope" value="SABCDE"/>全部<br/>--%>
					<c:if test="${fn:contains(article.scope,'S') eq true}">
						<form:checkbox path="scope" value="S" checked="checked"/>管理员<br/>
					</c:if>
					<c:if test="${fn:contains(article.scope,'S') eq false}">
						<form:checkbox path="scope" value="S"/>管理员<br/>
					</c:if>
					<c:if test="${fn:contains(article.scope,'A') eq true}">
						<form:checkbox path="scope" value="A" checked="checked"/>王者<br/>
					</c:if>
					<c:if test="${fn:contains(article.scope,'A') eq false}">
						<form:checkbox path="scope" value="A"/>王者<br/>
					</c:if>
					<c:if test="${fn:contains(article.scope,'B') eq true}">
						<form:checkbox path="scope" value="B" checked="checked"/>钻石<br/>
					</c:if>
					<c:if test="${fn:contains(article.scope,'B') eq false}">
						<form:checkbox path="scope" value="B"/>钻石<br/>
					</c:if>
					<c:if test="${fn:contains(article.scope,'C') eq true}">
						<form:checkbox path="scope" value="C" checked="checked"/>黄金<br/>
					</c:if>
					<c:if test="${fn:contains(article.scope,'C') eq false}">
						<form:checkbox path="scope" value="C"/>黄金<br/>
					</c:if>
					<c:if test="${fn:contains(article.scope,'D') eq true}">
						<form:checkbox path="scope" value="D" checked="checked"/>白银<br/>
					</c:if>
					<c:if test="${fn:contains(article.scope,'D') eq false}">
						<form:checkbox path="scope" value="D"/>白银<br/>
					</c:if>
					<c:if test="${fn:contains(article.scope,'E') eq true}">
						<form:checkbox path="scope" value="E" checked="checked"/>青铜<br/>
					</c:if>
					<c:if test="${fn:contains(article.scope,'E') eq false}">
						<form:checkbox path="scope" value="E"/>青铜<br/>
					</c:if>

				<%--<form:checkbox path="scope" value="B"/><br/>--%>
				<%--<form:checkbox path="scope" value="C"/><br/>--%>
				<%--<form:checkbox path="scope" value="D"/><br/>--%>
				<%--<form:checkbox path="scope" value="E"/><br/>--%>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">发布时间:</label>
			<div class="controls">
				<c:if test="${article.sendDate eq null || article.sendDate eq ''}">
					<input type="radio" name="sendDateType"  id="immediately" value="0" checked="checked"/>立即
					<input type="radio" name="sendDateType"id="timing" value="1"/>定时
				</c:if>
				<c:if test="${article.sendDate ne null && article.sendDate ne ''}">
					<input type="radio" name="sendDateType"  value="0"  id="immediately"/>立即
					<input type="radio" name="sendDateType"id="timing"  value="1"  checked="checked"/>定时
				</c:if>

				<%--<form:radiobutton path="sendDateType" checked="true" value="0" id="immediately"/>立即--%>
				<%--<form:radiobutton path="sendDateType" checked ="false" value="1" id="timing"/>定时--%>
				<input id="sendDate" name="sendDate" type="text" <c:if test="${article.sendDate eq null }"> style="display: none" </c:if>  readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${article.sendDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
			</div>
		</div>
		<%--<shiro:hasPermission name="cms:article:audit">--%>
			<%--<div class="control-group">--%>
				<%--<label class="control-label">发布状态:</label>--%>
				<%--<div class="controls">--%>
					<%--<form:radiobuttons path="delFlag" items="${fns:getDictList('cms_del_flag')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>--%>
					<%--<span class="help-inline"></span>--%>
				<%--</div>--%>
			<%--</div>--%>
		<%--</shiro:hasPermission>--%>

		<div class="form-actions">
			<shiro:hasPermission name="cms:article:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>