<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#no").focus();
			$("#btnCancel232").click(function () {


            });
			$("#inputForm").validate({

			
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/youka/user/list">用户列表</a></li>
		<li class="active"><a href="${ctx}/youka/user/form?id=${user.id}">用户<shiro:hasPermission name="sys:user:edit">添加</shiro:hasPermission><shiro:lacksPermission name="sys:user:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="youkaUser" action="${ctx}/youka/user/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">头像:</label>
			<div class="controls">
				<form:hidden id="nameImage" path="avatar" htmlEscape="false" maxlength="255" class="input-xlarge"/>
				<sys:ckfinder input="nameImage" type="images" uploadPath="/photo" selectMultiple="false" maxWidth="100" maxHeight="100"/>
			</div>
		</div>
		<c:if test="${empty userLevel}">
			<div class="control-group">
				<label class="control-label">来源:</label>
				<div class="controls">
					<form:select path="belongTo" cssStyle="width: 100px">
						<form:option value="B">
							佰邦达
						</form:option>
						<form:option value="S">
							盛世互通
						</form:option>
					</form:select>
				</div>
			</div>
		</c:if>

		<div class="control-group">
			<label class="control-label">用户类型:</label>
			<div class="controls">
				<form:select path="level" cssStyle="width: 100px">
					<c:if test="${empty userLevel}">
						<form:option value="A">
							王者会员
						</form:option>
					</c:if>
					<c:if test="${userLevel=='A'}" >
						<form:option value="B">
							钻石会员
						</form:option>
					</c:if>
					<c:if test="${userLevel=='B'}" >
						<form:option value="E">
							青铜会员
						</form:option>
					</c:if>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机号:</label>
			<div class="controls">
                <form:input path="mobile" type="number"  htmlEscape="false" maxlength="50" class="input-medium required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">密码:</label>
			<div class="controls">
				<input id="password" name="password" type="password" value="" maxlength="50" minlength="3" class="required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>

		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>

			<%--<div>--%>
				<%--<input name="iiii" value="78237832">--%>
				<%--<a id="btnCancel232" href="" > 测的是</a>--%>
			<%--</div>--%>

		</div>
	</form:form>
</body>
</html>