<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>待升级会员</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出用户数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/youka/user/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"导入数据", buttons:{"关闭":true}, 
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
		});
		function page(n,s){
			if(n) $("#pageNo").val(n);
			if(s) $("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/youka/user/upgradeUserlist");
			$("#searchForm").submit();
	    	return false;
	    }
	</script>
</head>
<body>
	<%--<div id="importBox" class="hide">--%>
		<%--<form id="importForm" action="${ctx}/youka/user/import" method="post" enctype="multipart/form-data"--%>
			<%--class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>--%>
			<%--<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　--%>
			<%--<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>--%>
			<%--<a href="${ctx}/youka/user/import/template">下载模板</a>--%>
		<%--</form>--%>
	<%--</div>--%>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/youka/user/upgradeUserlist">用户列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="upgradeUserEntity" action="${ctx}/youka/user/upgradeUserlist" method="post" class="breadcrumb form-search ">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<sys:tableSort id="orderBy" name="orderBy" value="${page.orderBy}" callback="page();"/>
		<ul class="ul-form">
			<li><label>用户名：</label><form:input path="nickname"></form:input></li>

			<li><label>手机号:</label><form:input path="mobile" htmlEscape="false" maxlength="50" class="input-medium"/></li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
				<%--<input id="btnExport" class="btn btn-primary" type="button" value="导出"/>--%>
				<%--<input id="btnImport" class="btn btn-primary" type="button" value="导入"/>--%>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead><tr><th>序号</th><th>用户名</th><th class="sort-column login_name">用户类型</th><th class="sort-column name">提交时间</th><th>手机号</th><th>变更手机号</th><th>所属王者</th><shiro:hasPermission name="youka:user:view"><th>操作</th></shiro:hasPermission></tr></thead>
		<tbody>
		<c:forEach items="${page.list}" var="user" varStatus="indexs">
			<tr>
				<td>${indexs.index}</td>
				<td>${user.nickname}</td>
				<td>
					<c:if test="${user.nowLevel eq 'S'}">管理员</c:if>
					<c:if test="${user.nowLevel eq 'A'}">王者会员</c:if>
					<c:if test="${user.nowLevel eq 'B'}">钻石会员</c:if>
					<c:if test="${user.nowLevel eq 'C'}">黄金会员</c:if>
					<c:if test="${user.nowLevel eq 'D'}">白银会员</c:if>
					<c:if test="${user.nowLevel eq 'E'}">青铜会员</c:if>
				</td>
				<td>
					<fmt:formatDate value="${user.createDate}" type="both" dateStyle="full"/>
				</td>
				<td>${user.mobile}</td>
				<td>
						${user.afterMobile}
				</td>
				<td>${user.recommendedMobile}</td>
				<shiro:hasPermission name="youka:rate:save"><td>
					<a href="${ctx}/youka/user/examine?mobile=${user.mobile}&afterMobile=${user.afterMobile}&orderCode=${user.orderCode}&level=${user.level}" >审核通过</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>