<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>结算管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$(".settlement").click(function () {
                var settlementDate = $("input[name='settlementDate']").val();
                if(settlementDate==''){

                    return false;
				}
                $(this).attr("href",$(this).attr("href")+"&settlementDate="+settlementDate);
            })
		});
		function page(n,s){
			if(n) $("#pageNo").val(n);
			if(s) $("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/youka/settlement/list");
			$("#searchForm").submit();
	    	return false;
	    }
	</script>
</head>
<body>

	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/youka/settlement/list">结算管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="youkaUser" action="${ctx}/youka/settlement/list" method="post" class="breadcrumb form-search ">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<sys:tableSort id="orderBy" name="orderBy" value="${page.orderBy}" callback="page();"/>
		<ul class="ul-form">
			<li><label>时间：</label>
				<input type="text" name="settlementDate" class="Wdate" id="test2" style="width:200px" onFocus="WdatePicker({dateFmt:'yyyy-MM'})" value="${youkaSettlement.settlementDate}"/>
			</li>

			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>

			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead><tr><th>序号</th><th>支付方式</th><th class="sort-column login_name">支付通道</th><th class="sort-column name">状态</th><shiro:hasPermission name="sys:user:edit"><th>操作</th></shiro:hasPermission></tr></thead>
		<tbody>
		<c:forEach items="${list}" var="settlement" varStatus="indexs">
			<tr>
				<td>${indexs.index}</td>
				<td>${settlement.payMethodName}</td>
				<td>
					${settlement.payChannelName}
				</td>
				<td>
					<c:if test="${settlement.status eq '0'}">未结算</c:if>
					<c:if test="${settlement.status eq '1'}">已结算</c:if>
				</td>

				<shiro:hasPermission name="youka:settlement:settlement">
					<td>
						<c:if test="${settlement.status eq '0'}"><a href="${ctx}/youka/settlement/settlement?payMethod=${settlement.payMethod}&payChannel=${settlement.payChannel}" class="settlement">结算</a></c:if>
					</td>
				</shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>