<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>交易管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
            $.ajax({
                url:"${ctx}/sys/dict/listDataByParent",
                type: "POST",
                data:
                    {
                        parentType:'pay_method',
                        parentValue:$("#payMethod").attr("value"),
                        type:'pay_channel'
                    }
                ,
                async:false,
                success: function(data){
                    $("#payChannel").empty();
                    // $("#payChannel").append('<option value="">全部</option>');
                    for(var i in data){

                        var payChannel = $("#payChannel").attr("title");
                        var dict = data[i];
                        if(payChannel == dict.value){
                            $("#payChannel").append('<option selected=selected value=' + dict.value + '> ' + dict.label + '</option>');
                        }else{
                            $("#payChannel").append('<option value=' + dict.value + '> ' + dict.label + '</option>');
                        }

                    }

                }
            })

        });
		function page(n,s){
			if(n) $("#pageNo").val(n);
			if(s) $("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/youka/benefit/listByUser");
			$("#searchForm").submit();
	    	return false;
	    }
	</script>
</head>
<body>

	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/youka/benefit/listByUser">交易列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="youkaBenefit" action="${ctx}/youka/benefit/listByUser" method="post" class="breadcrumb form-search ">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<sys:tableSort id="orderBy" name="orderBy" value="${page.orderBy}" callback="page();"/>
		<ul class="ul-form">
			<li><label>交易人：</label><form:input path="nickname"></form:input></li>
			<%--<li><label>支付渠道：</label>--%>
				<%--<select title="${payChannel}" name="payChannel" id="payChannel" style="width: 150px;">--%>

				<%--</select>--%>
			<%--</li>--%>
			<li><label>交易状态：</label>
				<form:select id="payStatus" path="orderEntity.payStatus" class="input-medium"><form:option value="" label=""/><form:options itemValue="value" itemLabel="label" items="${fns:getDictList('pay_status')}" htmlEscape="false"/></form:select>
			</li>
			<li><label>时间：</label>
				<input id="startTime" name="startTime" type="text" readonly="readonly" maxlength="20" class="input-small Wdate"
					   value="<fmt:formatDate value="${youkaBenefit.startTime}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>

				<input id="endTime" name="endTime" type="text" readonly="readonly" maxlength="20" class="input-small Wdate"
					   value="<fmt:formatDate value="${youkaBenefit.endTime}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>

			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
				<%--<input id="btnExport" class="btn btn-primary" type="button" value="导出"/>--%>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead><tr><th>序号</th><th>订单号</th><th class="sort-column login_name">交易时间</th><th class="sort-column name">交易人电话</th><th>交易平台</th><th>状态</th><th>订单金额</th><th>产生分润</th></tr></thead>
		<tbody>
		<c:forEach items="${page.list}" var="benefit" varStatus="indexs">
			<tr>
				<td>${indexs.index}</td>
				<td>${benefit.orderEntity.payCode}</td>
				<td><fmt:formatDate value="${benefit.orderEntity.createDate}" type="both" dateStyle="full"/></td>
				<td>
						${benefit.orderEntity.nickname}
				</td>
				<td>
					${benefit.orderEntity.payChannelName}
				</td>
				<td>
					<c:if test="${benefit.orderEntity.payStatus eq '0'}">待支付</c:if>
					<c:if test="${benefit.orderEntity.payStatus eq '1'}">支付中</c:if>
					<c:if test="${benefit.orderEntity.payStatus eq '2'}">已支付</c:if>
					<c:if test="${benefit.orderEntity.payStatus eq '3'}">逾期取消</c:if>
					<c:if test="${benefit.orderEntity.payStatus eq '4'}">支付失败</c:if>
				</td>
				<td>${benefit.amount}</td>
				<td>${benefit.orderEntity.benefitAmount}</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>