package com.thinkgem.jeesite.modules.youka.web;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.youka.entity.YoukaSettlement;
import com.thinkgem.jeesite.modules.youka.entity.YoukaUser;
import com.thinkgem.jeesite.modules.youka.service.YoukaSettlementService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author niehh
 * @Description: 结算
 * @date 2018年03月06日 11:53
 */
@Controller
@RequestMapping(value = "${adminPath}/youka/settlement")
public class YoukaSettlementController {

    @Autowired
    private YoukaSettlementService youkaSettlementService;

    @RequiresPermissions("youka:settlement:view")
    @RequestMapping(value = {"list", ""})
    public String list(YoukaSettlement youkaSettlement, HttpServletRequest request, HttpServletResponse response, Model model) {
        if(StringUtils.isBlank(youkaSettlement.getSettlementDate())){
            youkaSettlement.setSettlementDate(DateUtils.getDate("yyyy-MM"));
        }
        model.addAttribute("list",youkaSettlementService.getList(youkaSettlement));
        model.addAttribute("youkaSettlement",youkaSettlement);
        return "/modules/youka/settlement/settlementList";
    }

    @RequiresPermissions("youka:settlement:settlement")
    @RequestMapping(value = {"settlement", ""})
    public String settlement(YoukaSettlement youkaSettlement, HttpServletRequest request, HttpServletResponse response, Model model){
        youkaSettlementService.save(youkaSettlement);
        return this.list(youkaSettlement,request,response,model);
    }
}
