package com.thinkgem.jeesite.modules.youka.web;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.youka.entity.OrderEntity;
import com.thinkgem.jeesite.modules.youka.entity.YoukaCardEntity;
import com.thinkgem.jeesite.modules.youka.entity.YoukaUser;
import com.thinkgem.jeesite.modules.youka.service.YoukaCardService;
import com.thinkgem.jeesite.modules.youka.service.YoukaOrderService;
import com.thinkgem.jeesite.modules.youka.service.YoukaUserDetailService;
import com.thinkgem.jeesite.modules.youka.service.YoukaUserService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author niehh
 * @Description: 优卡用户
 * @date 2018年03月06日 11:53
 */

@Controller
@RequestMapping(value = "${adminPath}/youka/order")
public class YoukaOrderController extends BaseController {

    @Autowired
    private YoukaOrderService youkaOrderService;



    /**
     * 订单列表
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequiresPermissions("youka:order:view")
    @RequestMapping(value = {"list", ""})
    public String list(OrderEntity orderEntity, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<OrderEntity> page = youkaOrderService.findPage(new Page<OrderEntity>(request, response), orderEntity);
        Double allMoney = youkaOrderService.getSum(orderEntity);
        model.addAttribute("page", page);
        model.addAttribute("orderEntity", orderEntity);
        request.setAttribute("allMoney",allMoney);
        return "modules/youka/order/orderList";
    }


    /**
     * 导出订单数据
     * @param orderEntity
     * @param request
     * @param response
     * @param redirectAttributes
     * @return
     */
    @RequiresPermissions("youka:order:view")
    @RequestMapping(value = "export", method= RequestMethod.POST)
    public String exportFile(OrderEntity orderEntity, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttributes) {
        try {
            String fileName = "订单数据"+ DateUtils.getDate("yyyyMMddHHmmss")+".xlsx";
            Page<OrderEntity> page = youkaOrderService.findPage(new Page<OrderEntity>(request, response, -1), orderEntity);
            new ExportExcel("订单数据", OrderEntity.class).setDataList(page.getList()).write(response, fileName).dispose();
            return null;
        } catch (Exception e) {
            addMessage(redirectAttributes, "导出订单失败！失败信息："+e.getMessage());
        }
        return "redirect:" + adminPath + "/order/list?repage";
    }

}
