package com.thinkgem.jeesite.modules.youka.service;

import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.youka.dao.YoukaCardDao;
import com.thinkgem.jeesite.modules.youka.dao.YoukaRateDao;
import com.thinkgem.jeesite.modules.youka.entity.UserSubMchId;
import com.thinkgem.jeesite.modules.youka.entity.YoukaCardEntity;
import com.thinkgem.jeesite.modules.youka.entity.YoukaRate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author niehh
 * @Description: 费率
 * @date 2018年03月09日 10:53
 */
@Service
@Transactional(readOnly = true)
public class YoukaRateService  extends CrudService<YoukaRateDao, YoukaRate> {

    @Autowired
    private YoukaUserService youkaUserService;

    @Autowired
    private JuHeZhongPayJFenService juHeZhongPayJFenService;

    public Map<String,YoukaRate>  getRateByUserLevel(YoukaRate entity) {
        Map<String,YoukaRate> map = dao.getRateByUserLevel(entity);
        return map;
    }

    @Transactional(readOnly = false)
    public void saveRate(YoukaRate youkaRate){
//        List<YoukaRate> list = entity.getList();
//        for(YoukaRate youkaRate:list){
//            youkaRate.setUserLevel(entity.getUserLevel());
            if(youkaRate.getCode() == null || "".equals(youkaRate.getCode())){
                youkaRate.setCode(IdGen.randomBase62(64));
                youkaRate.preInsert();
                dao.insert(youkaRate);
            }else{
                youkaRate.preUpdate();
                dao.update(youkaRate);

                List<UserSubMchId> list = youkaUserService.getUserSubmchid(ComCode.PAYCHANNEL_HL2,youkaRate.getUserLevel());

                for(UserSubMchId userSubMchId:list){
                    try {
                        juHeZhongPayJFenService.merchantFeelJFen(userSubMchId.getSubmchid(),youkaRate);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
//        }
    }

    public YoukaRate getRateByCode(String code){
        YoukaRate youkaRate = new YoukaRate();
        youkaRate.setCode(code);
        return dao.getRateByCode(youkaRate);
    }
}
