package com.thinkgem.jeesite.modules.youka.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * @author niehh
 * @Description: 优卡用户银行卡
 * @date 2018年03月06日 14:39
 */
public class YoukaCardEntity extends DataEntity<YoukaCardEntity> {
    @JsonIgnore
    private String userCode; // 用户code
    private String cardType; // 银行卡类型 D储蓄卡 C信用卡
    private String cardNo; // 卡号
    @JsonIgnore
    private String cardMobile; // 预留手机号
    @JsonIgnore
    private String belongBank; // 所属银行
    @JsonIgnore
    private String cardBank; // 开户支行
    @JsonIgnore
    private String cardPlace; // 开户地点
    private String isDebit; // 是否是结算卡 Y是 N否

    private String isNewDebit;

    private String code;

    public YoukaCardEntity() {
    }

    public YoukaCardEntity(String code, String userCode, String cardType, String cardNo, String cardMobile, String belongBank, String cardBank, String cardPlace, String isDebit) {
        this.setCode(code);
        this.userCode = userCode;
        this.cardType = cardType;
        this.cardNo = cardNo;
        this.cardMobile = cardMobile;
        this.belongBank = belongBank;
        this.cardBank = cardBank;
        this.cardPlace = cardPlace;
        this.isDebit = isDebit;
        this.delFlag = "0";

    }

    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getCardType() {
        return cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getCardMobile() {
        return cardMobile;
    }

    public void setCardMobile(String cardMobile) {
        this.cardMobile = cardMobile;
    }

    public String getBelongBank() {
        return belongBank;
    }

    public void setBelongBank(String belongBank) {
        this.belongBank = belongBank;
    }

    public String getCardBank() {
        return cardBank;
    }

    public void setCardBank(String cardBank) {
        this.cardBank = cardBank;
    }

    public String getCardPlace() {
        return cardPlace;
    }

    public void setCardPlace(String cardPlace) {
        this.cardPlace = cardPlace;
    }

    public String getIsDebit() {
        return isDebit;
    }

    public void setIsDebit(String isDebit) {
        this.isDebit = isDebit;
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getIsNewDebit() {
        return isNewDebit;
    }

    public void setIsNewDebit(String isNewDebit) {
        this.isNewDebit = isNewDebit;
    }
}
