package com.thinkgem.jeesite.modules.youka.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

import java.util.Date;

public class YoukaBenefit  extends DataEntity<YoukaBenefit> {
    private String userCode; // 用户code
    private String orderCode; // 订单code
    private String payChannel; // 来源渠道
    private String payMethod;
    private String benefitStatus; // 分润状态 0不可提现 1可以提现

    private String benefitType; // 分润类型 A收益 M提现
    private String amount; // 金额
    private String cardCode; // 提现卡code

    private Date startTime;

    private Date endTime;

    private Date createDate;

    private OrderEntity orderEntity;

    private String code;

    private String startDate;

    private String endDate;

    private String nickname;

    private String mobile;

    private String balance;

    public YoukaBenefit() {
    }


    @ExcelField(title="时间" ,align=2, sort=50)
    public Date getCreateDate(){
        return createDate;
    }
    public void setCreateDate(Date createDate){
        this.createDate= createDate;
    }
    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getPayChannel() {
        return payChannel;
    }

    public void setPayChannel(String payChannel) {
        this.payChannel = payChannel;
    }

    public String getBenefitStatus() {
        return benefitStatus;
    }

    public void setBenefitStatus(String benefitStatus) {
        this.benefitStatus = benefitStatus;
    }
    @ExcelField(title="分润类型", align=2, sort=30 ,dictType = "benefit_type")
    public String getBenefitType() {
        return benefitType;
    }

    public void setBenefitType(String benefitType) {
        this.benefitType = benefitType;
    }
    @ExcelField(title="支出金额", align=2, sort=35)
    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getCardCode() {
        return cardCode;
    }

    public void setCardCode(String cardCode) {
        this.cardCode = cardCode;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
    @ExcelField(title="订单号",value = "orderEntity.payCode" ,align=2, sort=45)
    public OrderEntity getOrderEntity() {
        return orderEntity;
    }

    public void setOrderEntity(OrderEntity orderEntity) {
        this.orderEntity = orderEntity;
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }
    @ExcelField(title="用户名", align=2, sort=20)
    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }
    @ExcelField(title="手机号", align=2, sort=25)
    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }
    @ExcelField(title="金额", align=2, sort=40)
    public String getBalance() {
        return balance;
    }

    public void setBalance(String balance) {
        this.balance = balance;
    }
}
