/**
 * Copyright &copy; 2012-2016 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.thinkgem.jeesite.modules.adv.service;

import java.util.Date;
import java.util.List;

import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.adv.entity.YoukaAdv;
import com.thinkgem.jeesite.modules.adv.dao.YoukaAdvDao;

/**
 * 轮播图Service
 * @author tangting
 * @version 2018-06-19
 */
@Service
@Transactional(readOnly = true)
public class YoukaAdvService extends CrudService<YoukaAdvDao, YoukaAdv> {

	public YoukaAdv get(String id) {
		return super.get(id);
	}
	
	public List<YoukaAdv> findList(YoukaAdv youkaAdv) {
		return super.findList(youkaAdv);
	}
	
	public Page<YoukaAdv> findPage(Page<YoukaAdv> page, YoukaAdv youkaAdv) {
		return super.findPage(page, youkaAdv);
	}

	@Override
	@Transactional(readOnly = false)
	public void save(YoukaAdv youkaAdv) {
		if(youkaAdv.getId() != null && !"".equals(youkaAdv.getId())){
			youkaAdv.preUpdate();
			youkaAdv.setUpdateDate(new Date());
			youkaAdv.setUpdateBy(UserUtils.getUser());
			dao.update(youkaAdv);
		}else{
			youkaAdv.preInsert();
			youkaAdv.setCode( IdGen.randomBase62(64));
			youkaAdv.setClicks("0");
			youkaAdv.setCreateBy(UserUtils.getUser());
			youkaAdv.setUpdateBy(UserUtils.getUser());
			youkaAdv.setUpdateDate(new Date());
			youkaAdv.setCreateDate(new Date());
			dao.insert(youkaAdv);
		}
	}
	
	@Transactional(readOnly = false)
	public void update(YoukaAdv youkaAdv) {
		youkaAdv.setStatus("2");
		dao.update(youkaAdv);
	}
	
}