<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#no").focus();
			$("#inputForm").validate({

			
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/youka/user/list">用户列表</a></li>
		<li class="active"><a href="${ctx}/youka/user/real/name/audit?id=${user.id}">用户<shiro:hasPermission name="sys:user:edit">实名审核</shiro:hasPermission><shiro:lacksPermission name="sys:user:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="youkaUser" action="${ctx}/youka/user/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">头像:</label>
			<div class="controls">
				<img src="${youkaUser.avatar}"/>

			</div>
		</div>
		<div class="control-group">
			<label class="control-label">用户登录名:</label>
			<div class="controls">
				${youkaUser.nickname}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">用户类型:</label>
			<div class="controls">
				<c:if test="${youkaUser.level eq 'S'}">管理员</c:if>
				<c:if test="${youkaUser.level eq 'A'}">王者会员</c:if>
				<c:if test="${youkaUser.level eq 'B'}">钻石会员</c:if>
				<c:if test="${youkaUser.level eq 'C'}">黄金会员</c:if>
				<c:if test="${youkaUser.level eq 'D'}">白银会员</c:if>
				<c:if test="${youkaUser.level eq 'E'}">青铜会员</c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">真实姓名:</label>
			<div class="controls">
                <c:if test="${youkaUser.youkaUserDetail != null }">
					${youkaUser.youkaUserDetail.realName}
				</c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">身份证号码:</label>
			<div class="controls">
				<c:if test="${youkaUser.youkaUserDetail != null }">
					${youkaUser.youkaUserDetail.idCard}
				</c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">身份证地址:</label>
			<div class="controls">
				<c:if test="${youkaUser.youkaUserDetail != null }">
					${youkaUser.youkaUserDetail.idCardPlace}
				</c:if>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">身份证图片:</label>
			<div class="controls">
				<c:if test="${youkaUser.youkaUserDetail != null }">
					<img src="${youkaUser.youkaUserDetail.idCardFront}">
					<img src="${youkaUser.youkaUserDetail.idCardBack}">
				</c:if>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">手持身份证图片:</label>
			<div class="controls">
				<c:if test="${youkaUser.youkaUserDetail != null }">
					<img src="${youkaUser.youkaUserDetail.idCardHold}">
				</c:if>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">银行卡正面:</label>
			<div class="controls">
				<c:if test="${youkaUser.youkaUserDetail != null }">
					<img src="${youkaUser.youkaUserDetail.debitCard}">
				</c:if>
			</div>
		</div>

		<div class="form-actions">
			<shiro:hasPermission name="sys:user:edit"><a class="btn btn-primary" href="${ctx}/youka/user/save?id=${youkaUser.id}&status=2">通过</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a class="btn btn-primary" href="${ctx}/youka/user/save?id=${youkaUser.id}&status=0">不通过</a>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>