package com.thinkgem.jeesite.modules.youka.web;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import com.thinkgem.jeesite.modules.youka.entity.YoukaCardEntity;
import com.thinkgem.jeesite.modules.youka.entity.YoukaUser;
import com.thinkgem.jeesite.modules.youka.service.YoukaCardService;
import com.thinkgem.jeesite.modules.youka.service.YoukaUserDetailService;
import com.thinkgem.jeesite.modules.youka.service.YoukaUserService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author niehh
 * @Description: 优卡用户
 * @date 2018年03月06日 11:53
 */

@Controller
@RequestMapping(value = "${adminPath}/youka/user")
public class YoukaUserController  extends BaseController {

    @Autowired
    private YoukaUserService youkaUserService;

    @Autowired
    private YoukaUserDetailService youkaUserDetailService;

    @Autowired
    private YoukaCardService youkaCardService;

    @ModelAttribute
    public YoukaUser get(@RequestParam(required=false) String id) {
        if (StringUtils.isNotBlank(id)){
            return youkaUserService.get(id);
        }else{
            return new YoukaUser();
        }
    }


    /**
     * 用户列表
     * @param youkaUser
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequiresPermissions("youka:user:view")
    @RequestMapping(value = {"list", ""})
    public String list(YoukaUser youkaUser, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<YoukaUser> page = youkaUserService.findPage(new Page<YoukaUser>(request, response), youkaUser);
        model.addAttribute("page", page);
        return "modules/youka/userList";
    }


    /**
     * 添加用户页面
     * @param youkaUser
     * @param model
     * @return
     */
    @RequiresPermissions("youka:user:view")
    @RequestMapping(value = "form")
    public String form(YoukaUser youkaUser, Model model) {
        model.addAttribute("youkaUser", youkaUser);
        return "modules/youka/userForm";
    }


    /**
     * 修改用户页面
     * @param youkaUser
     * @param model
     * @return
     */
    @RequiresPermissions("youka:user:view")
    @RequestMapping(value = "modify")
    public String modify(YoukaUser youkaUser, Model model) {
        model.addAttribute("youkaUser", youkaUser);
        if(youkaUser != null && youkaUser.getCode() != null){
            youkaUser.setYoukaUserDetail(youkaUserDetailService.getByUserCode(youkaUser.getCode()));
            YoukaCardEntity youkaCardEntity = new YoukaCardEntity();
            youkaCardEntity.setUserCode(youkaUser.getCode());
            youkaUser.setYoukaCardEntityList(youkaCardService.findList(youkaCardEntity));
        }

        return "modules/youka/userModify";
    }


    /**
     * 实名认证页面
     * @param youkaUser
     * @param model
     * @return
     */
    @RequiresPermissions("youka:user:view")
    @RequestMapping(value = "real/name/audit")
    public String realNameAudit(YoukaUser youkaUser, Model model) {
        model.addAttribute("youkaUser", youkaUser);
        if(youkaUser != null && youkaUser.getCode() != null){
            youkaUser.setYoukaUserDetail(youkaUserDetailService.getByUserCode(youkaUser.getCode()));
        }
        return "modules/youka/userRealNameAudit";
    }

    /**
     * 保存或修改用户
     * @param youkaUser
     * @param model
     * @return
     */
    @RequiresPermissions("youka:user:view")
    @RequestMapping(value = "save")
    public String save(YoukaUser youkaUser, Model model, RedirectAttributes redirectAttributes){
        // 判断业务入参是否为空
        if (StringUtils.isBlank(youkaUser.getMobile()) || StringUtils.isBlank(youkaUser.getPassword())) {
            addMessage(model, "手机号或密码为空");
            return form(youkaUser, model);
        }

        // 查询注册手机号是否存在
        if(youkaUser.getId()==null || "".equals(youkaUser.getId())){
            if (youkaUserService.checkMobile(youkaUser) != null) {
                addMessage(model, "手机号已存在");
                return form(youkaUser,model);
            }
        }


        try {
            youkaUserService.save(youkaUser);
            addMessage(redirectAttributes, "保存用户'" + youkaUser.getMobile() + "'成功");
            return "redirect:" + adminPath + "/youka/user/list?repage";
        }catch (Exception e){

            addMessage(redirectAttributes, "保存用户'" + youkaUser.getMobile() + "失败");
            e.printStackTrace();
        }
        return "redirect:" + adminPath + "/youka/user/list?repage";
    }
}
