package com.thinkgem.jeesite.modules.youka.web;

import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.youka.entity.YoukaRate;
import com.thinkgem.jeesite.modules.youka.service.YoukaRateService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import java.util.List;

/**
 * @author niehh
 * @Description:
 * @date 2018年03月09日 14:24
 */
@Controller
@RequestMapping(value = "${adminPath}/youka/rate")
public class YoukaRateController  extends BaseController {


    @Autowired
    private YoukaRateService youkaRateService;

    @RequiresPermissions("youka:rate:view")
    @RequestMapping(value = "form")
    public String form(YoukaRate youkaRate, Model model){
        if(youkaRate==null){
            youkaRate = new YoukaRate();
        }
        if(StringUtils.isBlank(youkaRate.getUserLevel()) ){
            youkaRate.setUserLevel("S");
        }
        List<YoukaRate> list = youkaRateService.getRateByUserLevel(youkaRate);

        model.addAttribute("",list);

        return "";
    }


    public String save(YoukaRate youkaRate, Model model, RedirectAttributes redirectAttributes){
        if(youkaRate ==null || StringUtils.isBlank(youkaRate.getUserLevel()) || youkaRate.getList() == null || youkaRate.getList().size() == 0){
            addMessage(model, "信息为空");
            return form(youkaRate, model);
        }
        try{
            youkaRateService.saveRate(youkaRate);
        }catch (Exception e){
            addMessage(model, "保存失败");
            e.printStackTrace();
            return form(youkaRate, model);
        }
        return "";
    }

}
