package com.thinkgem.jeesite.modules.youka.service;

import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.youka.dao.YoukaCardDao;
import com.thinkgem.jeesite.modules.youka.dao.YoukaRateDao;
import com.thinkgem.jeesite.modules.youka.entity.YoukaCardEntity;
import com.thinkgem.jeesite.modules.youka.entity.YoukaRate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author niehh
 * @Description: 费率
 * @date 2018年03月09日 10:53
 */
@Service
@Transactional(readOnly = true)
public class YoukaRateService  extends CrudService<YoukaRateDao, YoukaRate> {

    public List<YoukaRate> getRateByUserLevel(YoukaRate entity) {
        List<YoukaRate> list = dao.getRateByUserLevel(entity);
        return list;
    }

    @Transactional(readOnly = false)
    public void saveRate(YoukaRate entity){
        List<YoukaRate> list = entity.getList();
        for(YoukaRate youkaRate:list){
            youkaRate.setUserLevel(entity.getUserLevel());
            if(youkaRate.getId() == null || "".equals(youkaRate.getId())){
                youkaRate.setCode(IdGen.randomBase62(64));
                youkaRate.preInsert();
                dao.insert(youkaRate);
            }else{
                youkaRate.preUpdate();
                dao.update(youkaRate);
            }
        }
    }
}
