package com.thinkgem.jeesite.modules.youka.service;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.youka.dao.YoukaBenefitDao;
import com.thinkgem.jeesite.modules.youka.dao.YoukaCardDao;
import com.thinkgem.jeesite.modules.youka.dao.YoukaOrderDao;
import com.thinkgem.jeesite.modules.youka.entity.OrderEntity;
import com.thinkgem.jeesite.modules.youka.entity.YoukaBenefit;
import com.thinkgem.jeesite.modules.youka.entity.YoukaCardEntity;
import com.thinkgem.jeesite.modules.youka.entity.YoukaUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.DecimalFormat;
import java.util.List;

/**
 * @author niehh
 * @Description:
 * @date 2018年03月07日 10:22
 */
@Service
@Transactional(readOnly = true)
public class YoukaOrderService extends CrudService<YoukaOrderDao, OrderEntity> {


    @Autowired
    private YoukaBenefitDao youkaBenefitDao;

    /**
     * 订单列表
     * @param page 分页对象
     * @param orderEntity
     * @return
     */
    public Page<OrderEntity> findPage(Page<OrderEntity> page, OrderEntity orderEntity){
        Page<OrderEntity> pages = super.findPage(page,orderEntity);

        List<OrderEntity> list = pages.getList();

        if(list!=null && list.size()>0){


            for(OrderEntity orderEntity1:list){

                // 目前只有快捷支付有分润
                if("quick".equals(orderEntity1.getPayMethod())){
                    YoukaBenefit youkaBenefit = new YoukaBenefit();
                    youkaBenefit.setOrderCode(orderEntity1.getPayCode());

                    // 查询分润
                    List<YoukaBenefit> youkaBenefits = youkaBenefitDao.getBenefitListByOrderCode(youkaBenefit);

                    // 统计分润总金额 和分润去向

                    // 分润金额
                    Double benefitAmount = new Double(0);

                    // 分润去向
                    StringBuffer stringBuffer = new StringBuffer();
                    if(youkaBenefits != null && youkaBenefits.size()>0){
                        for(YoukaBenefit youkaBenefit1:youkaBenefits){
                            benefitAmount += Double.valueOf(youkaBenefit1.getAmount());
                            stringBuffer.append(youkaBenefit1.getNickname());
                            stringBuffer.append("-");
                            stringBuffer.append(youkaBenefit1.getAmount()).append(";");
                        }
                    }

                    DecimalFormat df = new DecimalFormat("######0.00");
                    orderEntity1.setBenefitAmount(df.format(benefitAmount));
                    orderEntity1.setBenefitDescribe(stringBuffer.toString());
                }

            }
        }

        return page;
    }
}
