package com.thinkgem.jeesite.modules.youka.service;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.MD5;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.cms.dao.ArticleDao;
import com.thinkgem.jeesite.modules.cms.entity.Article;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import com.thinkgem.jeesite.modules.youka.dao.YoukaCardDao;
import com.thinkgem.jeesite.modules.youka.dao.YoukaUserDao;
import com.thinkgem.jeesite.modules.youka.dao.YoukaUserDetailDao;
import com.thinkgem.jeesite.modules.youka.entity.YoukaCardEntity;
import com.thinkgem.jeesite.modules.youka.entity.YoukaUser;
import com.thinkgem.jeesite.modules.youka.entity.YoukaUserDetail;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @author niehh
 * @Description: 优卡用户
 * @date 2018年03月05日 15:51
 */

@Service
@Transactional(readOnly = true)
public class YoukaUserService extends CrudService<YoukaUserDao, YoukaUser> {

    @Autowired
    private YoukaUserDetailDao youkaUserDetailDao;

    @Autowired
    private YoukaCardDao youkaCardDao;


    @Override
    public YoukaUser get(String id){
        YoukaUser user = dao.get(id);
        if(user != null && user.getAvatar() != null){
            user.setAvatar(Global.IMAGE_SAVE_URL + user.getAvatar());
        }

        return user;
    }

    @Override
    @Transactional(readOnly = false)
    public void save(YoukaUser youkaUser){
        if(youkaUser.getId() != null && !"".equals(youkaUser.getId())){
//            youkaUser.setUpdateBy(UserUtils.getUser());
            youkaUser.preUpdate();
            youkaUser.setAvatar(StringUtils.replace(youkaUser.getAvatar(), Global.IMAGE_SAVE_URL,""));
            dao.update(youkaUser);
            YoukaUserDetail youkaUserDetail = youkaUser.getYoukaUserDetail();
            if(youkaUserDetail != null){
                youkaUserDetail.preUpdate();
                youkaUserDetail.setIdCardFront(StringUtils.replace(youkaUserDetail.getIdCardFront(), Global.IMAGE_SAVE_URL,""));
                youkaUserDetail.setIdCardBack(StringUtils.replace(youkaUserDetail.getIdCardBack(), Global.IMAGE_SAVE_URL,""));
                youkaUserDetail.setIdCardHold(StringUtils.replace(youkaUserDetail.getIdCardHold(), Global.IMAGE_SAVE_URL,""));
                youkaUserDetail.setDebitCard(StringUtils.replace(youkaUserDetail.getDebitCard(), Global.IMAGE_SAVE_URL,""));

                youkaUserDetail.setUpdateBy(UserUtils.getUser());
                youkaUserDetail.setUserCode(youkaUser.getCode());
                if(youkaUserDetailDao.getByUserCode(youkaUser.getCode()) == null){
                    youkaUserDetail.preInsert();
                    youkaUserDetail.setCode(IdGen.randomBase62(64));
                    youkaUserDetailDao.insert(youkaUserDetail);
                }else{
                    youkaUserDetailDao.update(youkaUserDetail);
                }

            }
            List<YoukaCardEntity> youkaCardEntityList = youkaUser.getYoukaCardEntityList();
            if(youkaCardEntityList!=null && youkaCardEntityList.size()>0){
                for(YoukaCardEntity youkaCardEntity : youkaCardEntityList){
                    if(youkaCardEntity.getIsDebit() != null && !youkaCardEntity.getIsDebit().equals(youkaCardEntity.getIsNewDebit())){
                        youkaCardEntity.setIsDebit(youkaCardEntity.getIsNewDebit());
                        youkaCardDao.updateIsDebit(youkaCardEntity);
                    }
                }
            }

        }else{
            youkaUser.preInsert();
            // 申请子商户号
            String subMerchantId = "subMerchantId" + DateUtils.formatDateTime(new Date());
            youkaUser.setSubMerchantId(subMerchantId);
            // 保存用户信息
            String code = IdGen.randomBase62(64);
            youkaUser.setNickname("E_"+youkaUser.getMobile());
            youkaUser.setBelongTo("B");
            youkaUser.setStatus("0");
            youkaUser.setCode(code);
            youkaUser.setAvatar(StringUtils.replace(youkaUser.getAvatar(), Global.IMAGE_SAVE_URL,""));
            youkaUser.setPassword(MD5.sign(youkaUser.getPassword(), ComCode.signCode, "utf-8"));
            dao.insert(youkaUser);
            YoukaUserDetail youkaUserDetail = youkaUser.getYoukaUserDetail();
            if(youkaUserDetail != null){
                youkaUserDetail.preInsert();

                youkaUserDetail.setIdCardFront(StringUtils.replace(youkaUserDetail.getIdCardFront(), Global.IMAGE_SAVE_URL,""));
                youkaUserDetail.setIdCardBack(StringUtils.replace(youkaUserDetail.getIdCardBack(), Global.IMAGE_SAVE_URL,""));
                youkaUserDetail.setIdCardHold(StringUtils.replace(youkaUserDetail.getIdCardHold(), Global.IMAGE_SAVE_URL,""));
                youkaUserDetail.setDebitCard(StringUtils.replace(youkaUserDetail.getDebitCard(), Global.IMAGE_SAVE_URL,""));
                youkaUserDetail.setUpdateBy(UserUtils.getUser());
                youkaUserDetail.setUserCode(youkaUser.getCode());
                youkaUserDetail.setCode(IdGen.randomBase62(64));
                youkaUserDetailDao.insert(youkaUserDetail);
            }

        }
    }


    public List<YoukaUser> findByIdIn(String[] ids){
        return dao.findByIdIn(ids);
    }

    public YoukaUser checkRecommend(YoukaUser youkaUser){
        return dao.checkRecommend(youkaUser);
    }

    public YoukaUser checkMobile(YoukaUser youkaUser){
        return dao.checkMobile(youkaUser);
    }

}
