package com.thinkgem.jeesite.modules.youka.web;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.youka.entity.OrderEntity;
import com.thinkgem.jeesite.modules.youka.entity.YoukaBenefit;
import com.thinkgem.jeesite.modules.youka.service.YoukaBenefitService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Controller
@RequestMapping(value = "${adminPath}/youka/benefit")
public class YoukaBenefitController extends BaseController {

    @Autowired
    private YoukaBenefitService youkaBenefitService;


    /**
     * 分润列表某个用户
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequiresPermissions("youka:benefit:view")
    @RequestMapping(value = {"listByUser", ""})
    public String listByUser(YoukaBenefit youkaBenefit, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<YoukaBenefit> page = youkaBenefitService.findPage(new Page<YoukaBenefit>(request, response), youkaBenefit);
        model.addAttribute("page", page);
        model.addAttribute("youkaBenefit", youkaBenefit);
        model.addAttribute("balance",youkaBenefitService.getBalance(youkaBenefit));

        return "modules/youka/benefit/benefitUserList";
    }

    /**
     * 分润列表
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequiresPermissions("youka:benefit:view")
    @RequestMapping(value = {"list", ""})
    public String list(YoukaBenefit youkaBenefit, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<YoukaBenefit> page = youkaBenefitService.findPage(new Page<YoukaBenefit>(request, response), youkaBenefit);
        model.addAttribute("page", page);
        model.addAttribute("youkaBenefit", youkaBenefit);

        return "modules/youka/benefit/benefitList";
    }

}
