package com.thinkgem.jeesite.modules.youka.service;

import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.youka.dao.UpgradeUserDao;
import com.thinkgem.jeesite.modules.youka.dao.YoukaUserDao;
import com.thinkgem.jeesite.modules.youka.entity.UpgradeUserEntity;
import com.thinkgem.jeesite.modules.youka.entity.YoukaUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly = true)
public class UpgradeUserService  extends CrudService<UpgradeUserDao, UpgradeUserEntity> {

    @Autowired
    private YoukaUserService youkaUserService;


    public void examine(UpgradeUserEntity upgradeUserEntity){
        YoukaUser youkaUser = youkaUserService.checkMobile(upgradeUserEntity.getMobile());
        YoukaUser youkaUserNew = new YoukaUser();
        youkaUserNew.setMobile(upgradeUserEntity.getAfterMobile());
        youkaUserNew.setPassword(youkaUser.getPassword());
        youkaUserNew.setRecommendedMobile(youkaUser.getRecommendedMobile());
        youkaUserNew.setOrderCode(upgradeUserEntity.getOrderCode());
        youkaUserService.save(youkaUserNew);

        upgradeUserEntity.setStatus("2");
        upgradeUserEntity.preUpdate();
        dao.update(upgradeUserEntity);

    }
}
