<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>订单管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
            $.ajax({
                url:"${ctx}/sys/dict/listDataByParent",
                type: "POST",
                data:
                    {
                        parentType:'pay_method',
                        parentValue:$("#payMethod").attr("value"),
                        type:'pay_channel'
                    }
                ,
                async:false,
                success: function(data){
                    $("#payChannel").empty();
                    // $("#payChannel").append('<option value="">全部</option>');
                    for(var i in data){

                        var payChannel = $("#payChannel").attr("title");
                        var dict = data[i];
                        if(payChannel == dict.value){
                            $("#payChannel").append('<option selected=selected value=' + dict.value + '> ' + dict.label + '</option>');
						}else{
                            $("#payChannel").append('<option value=' + dict.value + '> ' + dict.label + '</option>');
						}

                    }

                }
            })
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出订单数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/youka/order/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"导入数据", buttons:{"关闭":true}, 
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});

			$("#payMethod").change(function () {

			    var parentValue = $(this).attr("value");
                $.ajax({
					url:"${ctx}/sys/dict/listDataByParent",
                    type: "POST",
					data:
						{
                        parentType:'pay_method',
                        parentValue:parentValue,
						type:'pay_channel'
					}
					,
					async:false,
                    success: function(data){
                        $("#payChannel").empty();
                        // $("#payChannel").append('<option value="">全部</option>');
                        for(var i in data){
                            var payChannel = $("#payChannel").attr("title");
                            console.log(payChannel)
                            var dict = data[i];
                            if(payChannel == dict.value){
                                $("#payChannel").append('<option selected="selected" value=' + dict.value + '> ' + dict.label + '</option>');
                            }else{
                                $("#payChannel").append('<option value=' + dict.value + '> ' + dict.label + '</option>');
                            }
						}

                    }
                })

            })
		});
		function page(n,s){
			if(n) $("#pageNo").val(n);
			if(s) $("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/youka/order/list");
			$("#searchForm").submit();
	    	return false;
	    }
	</script>
</head>
<body>

	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/youka/order/list">订单列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="orderEntity" action="${ctx}/youka/order/list" method="post" class="breadcrumb form-search ">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<sys:tableSort id="orderBy" name="orderBy" value="${page.orderBy}" callback="page();"/>
		<ul class="ul-form">
			<li><label>交易人：</label><form:input path="keywords"></form:input></li>
			<li><label>支付方式：</label>
				<form:select id="payMethod" path="payMethod" class="input-medium"><form:option value="" label=""/><form:options itemValue="value" itemLabel="label" items="${fns:getDictList('pay_method')}" htmlEscape="false"/></form:select>
				<%--<form:select cssStyle="width: 100px;" id="payMethod" path="payMethod" items="${fns:getDictList('pay_method')}" itemLabel="label" itemValue="value" htmlEscape="true" />--%>
			</li>
			<li><label>支付渠道：</label>
				<select title="${orderEntity.payChannel}" name="payChannel" id="payChannel" style="width: 150px;">

				</select>
			</li>
			<li><label>交易状态：</label>
				<form:select id="payStatus" path="payStatus" class="input-medium"><form:option value="" label=""/><form:options itemValue="value" itemLabel="label" items="${fns:getDictList('pay_status')}" htmlEscape="false"/></form:select>
				<%--<form:select path="payStatus" cssStyle="width: 100px">
					<form:option value="">
						全部状态
					</form:option>
					<form:option value="0">
						待支付
					</form:option>
					<form:option value="1">
						支付中
					</form:option>
					<form:option value="2">
						已支付
					</form:option>
					<form:option value="3">
						逾期取消
					</form:option>
					<form:option value="4">
						支付失败
					</form:option>
				</form:select>
				--%>
			</li>

			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
				<input id="btnExport" class="btn btn-primary" type="button" value="导出"/>
				<%--<input id="btnImport" class="btn btn-primary" type="button" value="导入"/>--%>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead><tr><th>序号</th><th>订单号</th><th class="sort-column login_name">交易时间</th><th class="sort-column name">交易人</th><th>交易平台</th><th>状态</th><th>订单金额</th><th>产生分润</th><th>分润去向</th></tr></thead>
		<tbody>
		<c:forEach items="${page.list}" var="order" varStatus="indexs">
			<tr>
				<td>${indexs.index}</td>
				<td>${order.payCode}</td>
				<td><fmt:formatDate value="${order.createDate}" type="both" dateStyle="full"/></td>
				<td>
						${order.nickname}
				</td>
				<td>
					${order.payMethodName}-${order.payChannelName}
				</td>
				<td>
					<c:if test="${order.payStatus eq '0'}">待支付</c:if>
					<c:if test="${order.payStatus eq '1'}">支付中</c:if>
					<c:if test="${order.payStatus eq '2'}">已支付</c:if>
					<c:if test="${order.payStatus eq '3'}">逾期取消</c:if>
					<c:if test="${order.payStatus eq '4'}">支付失败</c:if>
				</td>
				<td>${order.amount}</td>
				<td>${order.benefitAmount}</td>
				<td>${order.benefitDescribe}</td>

			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>