<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>分润管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

            $("#btnExport").click(function(){
                top.$.jBox.confirm("确认要导出分润数据吗？","系统提示",function(v,h,f){
                    if(v=="ok"){
                        $("#searchForm").attr("action","${ctx}/youka/benefit/export");
                        $("#searchForm").submit();
                    }
                },{buttonsFocus:1});
                top.$('.jbox-body .jbox-icon').css('top','55px');
            });
        });


			<%--$("#btnExport").click(function(){--%>
				<%--top.$.jBox.confirm("确认要导出订单数据吗？","系统提示",function(v,h,f){--%>
					<%--if(v=="ok"){--%>
						<%--$("#searchForm").attr("action","${ctx}/youka/benefit/export");--%>
						<%--$("#searchForm").submit();--%>
					<%--}--%>
				<%--},{buttonsFocus:1});--%>
				<%--top.$('.jbox-body .jbox-icon').css('top','55px');--%>
			<%--});--%>
			<%--$("#btnImport").click(function(){--%>
				<%--$.jBox($("#importBox").html(), {title:"导入数据", buttons:{"关闭":true}, --%>
					<%--bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});--%>
			<%--});--%>

		function page(n,s){
			if(n) $("#pageNo").val(n);
			if(s) $("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/youka/benefit/list");
			$("#searchForm").submit();
	    	return false;
	    }
	</script>
</head>
<body>

	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/youka/benefit/list">分润列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="youkaBenefit" action="${ctx}/youka/benefit/list" method="post" class="breadcrumb form-search ">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<sys:tableSort id="orderBy" name="orderBy" value="${page.orderBy}" callback="page();"/>
		<ul class="ul-form">
			<li><label>利润类型：</label><form:select id="benefitType" path="benefitType" class="input-medium"><form:option value="" label=""/><form:options itemValue="value" itemLabel="label" items="${fns:getDictList('benefit_type')}" htmlEscape="false"/></form:select></li>
			<li><label>时间：</label>
				<input id="startTime" name="startTime" type="text" readonly="readonly" maxlength="20" class="input-small Wdate"
					   value="<fmt:formatDate value="${youkaBenefit.startTime}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>

				<input id="endTime" name="endTime" type="text" readonly="readonly" maxlength="20" class="input-small Wdate"
					   value="<fmt:formatDate value="${youkaBenefit.endTime}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>

			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
				<input id="btnExport" class="btn btn-primary" type="button" value="导出"/>
				<%--<input id="btnImport" class="btn btn-primary" type="button" value="导入"/>--%>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead><tr><th>序号</th><th>用户名</th><th class="sort-column login_name">手机号</th><th class="sort-column name">分润类型</th><th>收入/支出</th><th>余额</th><th>订单号</th><th>时间</th></tr></thead>
		<tbody>
		<c:forEach items="${page.list}" var="benefit" varStatus="indexs">
			<tr>
				<td>${indexs.index}</td>
				<td>${benefit.nickname}</td>
				<td>${benefit.mobile}</td>
				<td>
					<c:if test="${benefit.benefitType eq 'A'}">收益</c:if>
					<c:if test="${benefit.benefitType eq 'M'}">提现</c:if>
				</td>
				<td>
					<c:if test="${benefit.benefitType eq 'A'}">+</c:if>
					<c:if test="${benefit.benefitType eq 'M'}">-</c:if>
					${benefit.amount}
				</td>
				<th>${benefit.balance}</th>
				<td>
						${benefit.orderEntity.payCode}
				</td>

				<td><fmt:formatDate value="${benefit.createDate}" type="both" dateStyle="full"/></td>

			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>